#include "oak.h"
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <strings.h>
#include <sys/wait.h>

struct action *action_create(char *name, int argc, char **argv) {
  /* returns an action whose funciton is looked up from "name" and
   * which has the arguments argv and arugment count argc
   */

  /* ******* NEED TO IMPLEMENT THIS ************** */
  return(NULL);
}

struct action *action_create_from_argstring(char *name, char *args) {
  /* returns an action whose function is looked up fromn "name" and
   * which has the arguemnts parsed from args, being space seperated */
  struct action *out;

  out=malloc(sizeof(struct action));
  out->name=strdup(name);
  out->argv=argstring_to_argv(args, &(out->argc));

  out->haslimits=0;
  
  return(out);
}

void action_set_limits(struct action *act, int lines, int linelen, int numhosts, int hostents) {
  act->haslimits=1;

  act->limit_lines=lines;
  act->limit_linelen=linelen;
  act->limit_numhosts=numhosts;
  act->limit_hostents=hostents;
}

void action_execute(struct action *act, struct queue *q) {
  /* execute the action */

  /* we probably should have compalined in readconfig if we don't know
   * the argv[0] action argc < 1.  Oh well, this is supposed to be a
   * quick hack
   */

  FILE *file;
  char command[1024];
  char *msg;
  int i;

  if (!act) return;

  if (act->argc<1) return;

  if (!DEBUG) {
    i=fork();  
    if (i) {
      wait3(NULL, WNOHANG, NULL);
      return;
    }
  }

  if (!strcmp(act->argv[0], "zwrite")) {
    if (DEBUG) printf("DEBUG: doing zwrite\n");
    /* need to fix this to get tickets and authenticate */
    /*
    msg=queue_to_string(q);
    send_zephyr(act->argv[1], act->argv[2], act->argv[3], msg, "", "oak");
    */

    putenv("KRBTKFILE=/tmp/tkt_oak");
    putenv("KRB5CCNAME=/tmp/tkt5_oak");
    system("/usr/athena/bin/klist -s > /dev/null 2> /dev/null || /usr/athena/bin/kinit -l 5m -k");
    if (!strcmp(act->argv[3], "*")) {
      sprintf(command, "/usr/athena/bin/zwrite -q -n -c %s -i %s >/dev/null 2>/dev/null", act->argv[1], act->argv[2]);
    } else {
      sprintf(command, "/usr/athena/bin/zwrite -q -n -c %s -i %s %s >/dev/null 2>/dev/null", act->argv[1], act->argv[2], act->argv[3]);
    }

    file=popen(command, "w");
    msg=NULL;
    if (act->haslimits) {
      msg=queue_to_string_truncate(q, act->limit_lines, act->limit_linelen, act->limit_numhosts, act->limit_hostents);
    } else {
      msg=queue_to_string_truncate(q, 25, 100, 100, 10);
    }
    if (msg) {
      fputs(msg, file);
      free(msg);
    }
    pclose(file);

  } else if (!strcmp(act->argv[0], "mail")) {
    if (DEBUG) printf("DEBUG: sending mail message\n");

    file=popen("/usr/lib/sendmail -t", "w");
    fprintf(file, "To: %s\n", act->argv[1]);
    fprintf(file, "From: %s\n", act->argv[2]);
    fprintf(file, "Subject: %s\n\n", act->argv[3]); /* yeah, I know, bug */
    if (act->haslimits) {
      msg=queue_to_string_truncate(q, act->limit_lines, act->limit_linelen, act->limit_numhosts, act->limit_hostents);
    } else {
      msg=queue_to_string_truncate(q, 300, 100, 100, 100);
    }
    if (msg) {
      fputs(msg, file);
      free(msg);
    }
    pclose(file);
  } else if (!strcmp(act->argv[0], "exec")) {
    int i;
    
    if (DEBUG) printf("DEBUG: going to exec command\n");

    strcpy(command, "");
    for (i=0; i<act->argc-1; i++) {
      strcat(command, act->argv[i+1]);
      strcat(command, " ");
    }

    if (DEBUG) printf("DEBUG: command is %s\n", command);
    file=popen(command, "w");

    msg=NULL;
    if (act->haslimits) {
      msg=queue_to_string_truncate(q, act->limit_lines, act->limit_linelen, act->limit_numhosts, act->limit_hostents);
    } else {
      msg=queue_to_string_truncate(q, 300, 100, 100, 100);
    }
    if (msg) {
      fputs(msg, file);
      free(msg);
    }
    pclose(file);
  } else {
    /* some kind of warning? */
  }
  if (!DEBUG) {
    exit(0);
  }
}

char *action_get_name(struct action *act) {
  return(act->name);
}
