#include "oak.h"
#include <stdlib.h>

/* general lists */
/* if there are no elements in a list then list->next = list */
   
oak_list *oak_list_create() {
  oak_list *out;

  out=malloc(sizeof(oak_list));
  out->element=NULL;
  out->next=out;
  return(out);
}

void oak_list_append_element(oak_list *list, void *in) {
  oak_list *tmp;

  if (list->next == list) {
    list->element=in;
    list->next=NULL; /* shouldn't really be necessary */
  } else {
    tmp=list;
    while (list->next) {
      tmp=tmp->next;
    }
    tmp->next=malloc(sizeof(oak_list));
    tmp=tmp->next;
    tmp->element=in;
    tmp->next=NULL;
  }
}

void *oak_list_get_element(oak_list *list, int index) {
  /* return the item indexed by "index", if it doesn't exist then return NULL */
  int count = 0;
  oak_list *tmp;

  if (list->next == list) return(NULL);
  
  tmp=list;
  while(tmp) {
    if (count==index) return(tmp->element);
    tmp=tmp->next;
    count++;
  }
  return(NULL);
}

int oak_list_get_size(oak_list *list) {
  int count = 0;
  oak_list *tmp;

  if (list->next == list) return(0);

  tmp=list;
  while (tmp) {
    count++;
    tmp=tmp->next;
  }
  return(count);
}
