#include <stdlib.h>
#include "oak.h"

struct matchlist *matchlist_append_matchline(struct matchlist *a, struct matchline *ml) {
  struct matchlist *tmp, *out;

  if (a==NULL) {
    tmp=malloc(sizeof(struct matchlist));
    tmp->line=ml;
    tmp->next=NULL;
    out=tmp;
  } else {
    tmp=a;
    while (tmp->next) {
      tmp=tmp->next;
    }
    tmp->next=malloc(sizeof(struct matchlist));
    tmp=tmp->next;
    tmp->line=ml;
    tmp->next=NULL;
    out=a;
  }

  return(out);
}

int matchlist_get_nummatches(struct matchlist *m) {
  /* return the number of matchlines */
  int count=0;
  struct matchlist *tml;

  tml=m;
  while (tml) {
    count++;
    tml=tml->next;
  }
  return(count);
}

struct matchline *matchlist_get_matchline_n(struct matchlist *m, int n) {
  /* return the nth matchline in the list, if it's out of bounds return NULL */
  int count=0;
  struct matchlist *tml;

  tml=m;
  while (tml) {
    if (count==n) return(tml->line);
    tml=tml->next;
    count++;
  }

  return(NULL);
}
