#include "oak.h"
#include <stdlib.h>

struct queuelist *queuelist_append_queue(struct queuelist *a, struct queue *q) {
  struct queuelist *tmp, *out;

  if (a==NULL) {
    tmp=malloc(sizeof(struct queuelist));
    tmp->queue=q;
    tmp->next=NULL;
    out=tmp;
  } else {
    tmp=a;
    while (tmp->next) {
      tmp=tmp->next;
    }
    tmp->next=malloc(sizeof(struct queuelist));
    tmp=tmp->next;
    tmp->queue=q;
    tmp->next=NULL;
    out=a;
  }

  return(out);
}


int queuelist_get_num_queues(struct queuelist *ql) {
  /* return the number of queues in the list */
  int count=0;
  struct queuelist *tql;

  tql=ql;
  while (tql) {
    count++;
    tql=tql->next;
  }
  return(count);
}

struct queue *queuelist_get_queue_n(struct queuelist *ql, int n) {
  /* return the nth queue, null if it's out of bounds */
  int count=0;
  struct queuelist *tql;

  tql=ql;
  while (tql) {
    if (count==n) return(tql->queue);
    tql=tql->next;
    count++;
  }

  return(NULL);
}

struct queue *queuelist_get_queue_by_name(struct queuelist *ql, char *name) {
  /* return the queue in the ql with name "name".  if it doesn't exist
     return NULL */
  struct queuelist *tql;
  
  tql=ql;
  while (tql) {
    if (!strcmp(name, queue_get_name(tql->queue))) return(tql->queue);
    tql=tql->next;
  }

  return(NULL);
}


struct queuelist *queuelist_remove_queue_n(struct queuelist *ql, int n) {
  struct queuelist *tql;
  int i;

  tql=ql;
  if (n==0) return(ql->next);

  /* get the one before the one we're removing */
  for (i=0; i<n-1; i++) {
    tql=tql->next;
  }

  tql->next=tql->next->next;
  return(ql);
}
