#include "oak.h"
#include <stdlib.h>
#include <sys/types.h>
#include <time.h>

struct timelist *timelist_append_time(struct timelist *a, time_t *t) {
  struct timelist *tmp, *out;

  if (a==NULL) {
    tmp=malloc(sizeof(struct timelist));
    tmp->time=t;
    tmp->next=NULL;
    out=tmp;
  } else {
    tmp=a;
    while (tmp->next) {
      tmp=tmp->next;
    }
    tmp->next=malloc(sizeof(struct timelist));
    tmp=tmp->next;
    tmp->time=t;
    tmp->next=NULL;
    out=a;
  }

  return(out);
}


int timelist_get_num_times(struct timelist *tl) {
  /* return the number of times in the list */
  int count=0;
  struct timelist *ttl;

  ttl=tl;
  while (ttl) {
    count++;
    ttl=ttl->next;
  }
  return(count);
}

time_t *timelist_get_time_n(struct timelist *tl, int n) {
  /* return the nth queue, null if it's out of bounds */
  int count=0;
  struct timelist *ttl;

  ttl=tl;
  while (ttl) {
    if (count==n) return(ttl->time);
    ttl=ttl->next;
    count++;
  }

  return(NULL);
}

struct timelist *timelist_remove_time_n(struct timelist *tl, int n) {
  struct timelist *ttl;
  int i;

  ttl=tl;
  if (n==0) return(tl->next);

  /* get the one before the one we're removing */
  for (i=0; i<n-1; i++) {
    ttl=ttl->next;
  }

  ttl->next=ttl->next->next;
  return(tl);
}
