#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "owl.h"


void owl_process_command(char *buff) {
  char **argv;
  int argc;
  char *tmpbuff;

  tmpbuff=strdup(buff);
  argv=owl_parseline(buff, &argc);
  if (argc < 0) {
    owl_function_makemsg("Unbalanced quotes");
    return;
  }
  
  if (argc < 1) return;

  if (!strcmp(argv[0], "")) {
    /* do nothing */
  } else if (!strcmp(argv[0], "quit") ||
	     !strcmp(argv[0], "exit") ||
	     !strcmp(argv[0], "q")) {
    owl_command_quit();
  } else if (!strcmp(argv[0], "info")) {
    owl_command_info();
  } else if (!strcmp(argv[0], "help")) {
    owl_command_help();
  } else if (!strcmp(argv[0], "version")) {
    owl_command_version();
  } else if (!strcmp(argv[0], "next")) {
    owl_command_next();
  } else if (!strcmp(argv[0], "prev")) {
    owl_command_prev();
  } else if (!strcmp(argv[0], "next-notdel")) {
    owl_command_next_notdeleted();
  } else if (!strcmp(argv[0], "prev-notdel")) {
    owl_command_prev_notdeleted();
  } else if (!strcmp(argv[0], "expunge")) {
    owl_command_expunge();
  } else if (!strcmp(argv[0], "last")) {
    owl_command_last();
  } else if (!strcmp(argv[0], "first")) {
    owl_command_first();
  } else if (!strcmp(argv[0], "resize")) {
    owl_command_resize();
  } else if (!strcmp(argv[0], "suspend")) {
    owl_command_suspend();
  } else if (!strcmp(argv[0], "echo")) {
    owl_command_echo(argc, argv);
  } else if (!strcmp(argv[0], "exec")) {
    owl_command_exec(argc, argv);
  } else if (!strcmp(argv[0], "unsub")) {
    owl_command_unsub();
  } else if (!strcmp(argv[0], "load-subs")) {
    owl_command_loadsubs(argc, argv);
  } else if (!strcmp(argv[0], "subscribe") || !strcmp(argv[0], "sub")) {
    owl_command_subscribe(argc, argv);
  } else if (!strcmp(argv[0], "zlog")) {
    owl_command_zlog(argc, argv);
  } else if (!strcmp(argv[0], "debug")) {
    owl_command_debug(argc, argv);
  } else if (!strcmp(argv[0], "set")) {
    owl_command_set(argc, argv);
  } else if (!strcmp(argv[0], "print")) {
    owl_command_print(argc, argv);
  } else if (!strcmp(argv[0], "ktest")) {
    owl_command_ktest(argc, argv);
  } else if (!strcmp(argv[0], "zwrite")) {
    if (argc < 2) {
      owl_function_makemsg("Not enough arguments to the zwrite command.");
    } else {
      owl_command_zwrite_setup(tmpbuff);
      owl_global_set_buffercommand(&g, tmpbuff);
    }
  } else if (!strcmp(argv[0], "reply")) {
    char buff[1024];
    owl_message *m;

    if (owl_messagelist_get_size(owl_global_get_msglist(&g))==0) {
      owl_function_makemsg("No message selected");
    } else {
      char *to;
      
      m=owl_messagelist_get_element(owl_global_get_msglist(&g), owl_global_get_curmsg(&g));

      if (owl_message_is_admin(m)) {
	owl_function_makemsg("You can not reply to an admin message");
      } else {
	to=owl_message_get_recipient(m);
	if (!strcmp(to, "") || !strcmp(to, "*")) {
	  to="";
	} else if (to[0]=='@') {
	  /* leave it, to get the realm */
	} else {
	  to=owl_message_get_sender(m);
	}
	
	/* create the command line */
	sprintf(buff, "zwrite -c '%s'", owl_message_get_class(m));
	if (*owl_message_get_instance(m) != '\0') {
	  sprintf(buff, "%s -i '%s'", buff, owl_message_get_instance(m));
	}
	if (*to != '\0') {
	  sprintf(buff, "%s %s", buff, to);
	}

	owl_command_zwrite_setup(buff);
	owl_global_set_buffercommand(&g, buff);
      }
    }
  } else if (!strcmp(argv[0], "zaway")) {
    owl_command_zaway(argc, argv);
  } else {
    char tmpbuff[1024];
    sprintf(tmpbuff, "Unknown command '%s'.", buff);
    owl_function_makemsg(tmpbuff);
  }
  owl_parsefree(argv, argc);
  free(tmpbuff);
  sepbar(NULL);
}


void owl_command_info() {
  owl_function_info();
}

void owl_command_help() {
  owl_function_help();
}

void owl_command_version() {
  char buff[1024];

  sprintf(buff, "Owl version %s", OWL_VERSION_STRING);
  owl_function_makemsg(buff);
}

void owl_command_next() {
  owl_function_nextmsg();
}

void owl_command_prev() {
  owl_function_prevmsg();
}

void owl_command_next_notdeleted() {
  owl_function_nextmsg_notdeleted();
}

void owl_command_prev_notdeleted() {
  owl_function_prevmsg_notdeleted();
}

void owl_command_delete_cur() {
  owl_function_deletecur();
}

void owl_command_undelete_curmsg() {
  owl_function_undeletecur();
}

void owl_command_expunge() {
  owl_function_expunge();
}

void owl_command_first() {
  owl_function_firstmsg();
}

void owl_command_last() {
  owl_function_lastmsg();
}

void owl_command_resize() {
  owl_function_resize();
}

void owl_command_shift_right() {
  owl_function_shift_right();
}

void owl_command_shift_left() {
  owl_function_shift_left();
}

void owl_command_unsub() {
  owl_function_unsub();
}

void owl_command_loadsubs(int argc, char **argv) {
  if (argc != 2) {
    owl_function_makemsg("Wrong number of arguments for load-subs.");
    return;
  }
  owl_function_loadsubs(argv[1]);
}

void owl_command_zwrite_setup(char *line) {
  owl_editwin *e;
  char buff[1024];
  owl_zwrite z;
  int ret;

  /* check the arguments */
  ret=owl_zwrite_create_from_line(&z, line);
  if (ret) {
    owl_function_makemsg("Error in zwrite arugments");
    owl_zwrite_free(&z);
    return;
  }

  /* send a ping if necessary */
  if (owl_global_is_txping(&g)) {
    owl_zwrite_send_ping(&z);
  }
  owl_zwrite_free(&z);

  /* create and setup the editwin */
  e=owl_global_get_typwin(&g);
  owl_editwin_new_style(e, OWL_EDITWIN_STYLE_MULTILINE);

  owl_function_makemsg("Type your zephyr below.  C-d to send C-c to quit.");

  owl_editwin_clear(e);
  strcpy(buff, "----> ");
  strcat(buff, line);
  strcat(buff, "\n");
  owl_editwin_set_locktext(e, buff);

  /* make it active */
  owl_global_set_typwin_active(&g);
}

void owl_command_zwrite(char *line) {
  char *tmpbuff, buff[1024];
  owl_zwrite z;

  /* create the zwrite and send the message */
  owl_zwrite_create_from_line(&z, line);
  owl_zwrite_send_message(&z, owl_editwin_get_text(owl_global_get_typwin(&g)));

  /* display the message as an admin message in the receive window */
  if (owl_global_get_displayoutgoing(&g) && owl_zwrite_is_personal(&z)) {
    tmpbuff=malloc(strlen(owl_editwin_get_text(owl_global_get_typwin(&g)))+1024);
    owl_zwrite_get_recipstr(&z, buff);
    sprintf(tmpbuff, "Message sent to %s", buff);
    owl_function_adminmsg(tmpbuff, owl_editwin_get_text(owl_global_get_typwin(&g)));
    free(tmpbuff);
  }

  /* log it if we have logging turned on */
  /* this breaks for multiple recips */
  if (owl_global_is_logging(&g) && owl_zwrite_is_personal(&z)) {
    owl_zwrite_get_recipstr(&z, buff);
    owl_log_outgoing(buff, owl_editwin_get_text(owl_global_get_typwin(&g)));
  }

  /* free the zwrite */
  owl_zwrite_free(&z);
}


void owl_command_suspend() {
  owl_function_suspend();
}

void owl_command_zaway(int argc, char **argv) {
  char buff[1024]; /* ick */
  int i;
  
  if (argc==1) {
    owl_function_zaway_on(NULL);
    return;
  }

  if (argc==2 && !strcmp(argv[1], "on")) {
    owl_function_zaway_on(NULL);
    return;
  }

  if (argc==2 && !strcmp(argv[1], "off")) {
    owl_function_zaway_off();
    return;
  }

  strcpy(buff, "");
  for (i=1; i<argc; i++) {
    strcat(buff, argv[i]);
    if (i!=argc-1) {
      strcat(buff, " ");
    }
  }
  owl_function_zaway_on(buff);
}


void owl_command_set(int argc, char **argv) {
  char *var, *val;

  if (argc != 3) {
    owl_function_makemsg("Wrong number of arguments for set command");
    return;
  }

  var=argv[1];
  val=argv[2];

  if (!strcmp(var, "bell")) {
    if (!strcmp(val, "on")) {
      owl_global_set_bell_on(&g);
      owl_function_makemsg("Bell on");
    } else if (!strcmp(val, "off")) {
      owl_global_set_bell_off(&g);
      owl_function_makemsg("Bell off");
    } else {
      owl_function_makemsg("Unknown bell subcommand");
    }
  } else if (!strcmp(var, "zsigproc")) {
    owl_global_set_zsig_exec(&g, val);
  } else if (!strcmp(var, "startuplogin")) {
    if (!strcmp(val, "on")) {
      owl_global_set_startuplogin_on(&g);
      owl_function_makemsg("startuplogin set to on");
    } else if (!strcmp(val, "off")) {
      owl_global_set_startuplogin_off(&g);
      owl_function_makemsg("startuplogin set to off");
    } else {
      owl_function_makemsg("Unknown setting for startuplogin variable.");
    }
  } else if (!strcmp(var, "shutdownlogout")) {
    if (!strcmp(val, "on")) {
      owl_global_set_shutdownlogout_on(&g);
      owl_function_makemsg("shutdownlogout set to on");
    } else if (!strcmp(val, "off")) {
      owl_global_set_shutdownlogout_off(&g);
      owl_function_makemsg("shutdownlogout set to off");
    } else {
      owl_function_makemsg("Unknown setting for startuplogin variable.");
    }
  } else if (!strcmp(var, "displayoutgoing")) {
    if (!strcmp(val, "on")) {
      owl_global_set_displayoutgoing_on(&g);
      owl_function_makemsg("displayoutgoing set to on");
    } else if (!strcmp(val, "off")) {
      owl_global_set_displayoutgoing_off(&g);
      owl_function_makemsg("displayoutgoing set to off");
    } else {
      owl_function_makemsg("Unknown setting for displayoutgoing variable.");
    }
  } else if (!strcmp(var, "loginsubs")) {
    if (!strcmp(val, "on")) {
      owl_global_set_loginsubs_on(&g);
      owl_function_makemsg("loginsubs set to on");
    } else if (!strcmp(val, "off")) {
      owl_global_set_loginsubs_off(&g);
      owl_function_makemsg("loginsubs set to off");
    } else {
      owl_function_makemsg("Unknown setting for loginsubs variable.");
    }
  } else if (!strcmp(var, "logging")) {
    if (!strcmp(val, "on")) {
      owl_global_set_logging_on(&g);
    } else if (!strcmp(val, "off")) {
      owl_global_set_logging_off(&g);
    } else {
      owl_function_makemsg("Unknown setting for logging variable.");
    }
  } else if (!strcmp(var, "classlogging")) {
    if (!strcmp(val, "on")) {
      owl_global_set_classlogging_on(&g);
    } else if (!strcmp(val, "off")) {
      owl_global_set_classlogging_off(&g);
    } else {
      owl_function_makemsg("Unknown setting for classlogging variable.");
    }
  } else if (!strcmp(var, "logpath")) {
    char buff[1024];
    owl_global_set_logpath(&g, val);
    sprintf(buff, "logpath set to %s", val);
    owl_function_makemsg(buff);
  } else if (!strcmp(var, "classlogpath")) {
    char buff[1024];
    owl_global_set_classlogpath(&g, val);
    sprintf(buff, "classlogpath set to %s", val);
    owl_function_makemsg(buff);
  } else if (!strcmp(var, "rxping")) {
    if (!strcmp(val, "on")) {
      owl_global_set_rxping_on(&g);
    } else if (!strcmp(val, "off")) {
      owl_global_set_rxping_off(&g);
    } else {
      owl_function_makemsg("Unknown setting for rxping variable.");
    }
  } else if (!strcmp(var, "txping")) {
    if (!strcmp(val, "on")) {
      owl_global_set_txping_on(&g);
    } else if (!strcmp(val, "off")) {
      owl_global_set_txping_off(&g);
    } else {
      owl_function_makemsg("Unknown setting for txping variable.");
    }
  } else if (!strcmp(var, "personalbell")) {
    if (!strcmp(val, "on")) {
      owl_global_set_personalbell_on(&g);
      owl_function_makemsg("pesonalbell set to on");
    } else if (!strcmp(val, "off")) {
      owl_global_set_personalbell_off(&g);
      owl_function_makemsg("pesonalbell set to off");
    } else {
      owl_function_makemsg("Unknown setting for personalbell variable.");
    }
  } else if (!strcmp(var, "typewinsize")) {
    int a=atoi(val);
    if (a==0) {
      owl_function_makemsg("Typeing window must be at least one line high.");
    } else {
      owl_function_resize_typwin(a);
      owl_function_makemsg("Typewin resized");
    }
  } else {
    owl_function_makemsg("Unknown variable");
  }
}

void owl_command_print(int argc, char **argv) {
  char *variable;
    
  if (argc!=2) {
    owl_function_makemsg("Wrong number of arguments for print command");
    return;
  }

  variable=argv[1];
  
  if (!strcmp(variable, "bell")) {
    if (owl_global_is_bell(&g)) {
      owl_function_makemsg("bell = on");
    } else {
      owl_function_makemsg("bell = off");
    }
  } else if (!strcmp(variable, "personalbell")) {
    if (owl_global_is_personalbell(&g)) {
      owl_function_makemsg("personalbell = on");
    } else {
      owl_function_makemsg("personalbell = off");
    }
  } else if (!strcmp(variable, "startuplogin")) {
    if (owl_global_get_startuplogin(&g)) {
      owl_function_makemsg("startuplogin = on");
    } else {
      owl_function_makemsg("startuplogin = off");
    }
  } else if (!strcmp(variable, "shutdownlogout")) {
    if (owl_global_get_shutdownlogout(&g)) {
      owl_function_makemsg("shutdownlogout = on");
    } else {
      owl_function_makemsg("shutdownlogout = off");
    }
  } else if (!strcmp(variable, "displayoutgoing")) {
    if (owl_global_get_displayoutgoing(&g)) {
      owl_function_makemsg("displayoutgoing = on");
    } else {
      owl_function_makemsg("displayoutgoing = off");
    }
  } else if (!strcmp(variable, "rxping")) {
    if (owl_global_is_rxping(&g)) {
      owl_function_makemsg("rxping = on");
    } else {
      owl_function_makemsg("rxping = off");
    }
  } else if (!strcmp(variable, "txping")) {
    if (owl_global_is_txping(&g)) {
      owl_function_makemsg("txping = on");
    } else {
      owl_function_makemsg("txping = off");
    }
  } else if (!strcmp(variable, "logging")) {
    if (owl_global_is_logging(&g)) {
      owl_function_makemsg("logging = on");
    } else {
      owl_function_makemsg("logging = off");
    }
  } else if (!strcmp(variable, "classlogging")) {
    if (owl_global_is_classlogging(&g)) {
      owl_function_makemsg("classlogging = on");
    } else {
      owl_function_makemsg("classlogging = off");
    }
  } else if (!strcmp(variable, "logpath")) {
    char buff[1024];
    sprintf(buff, "logpath = %s", owl_global_get_logpath(&g));
    owl_function_makemsg(buff);
  } else if (!strcmp(variable, "classlogpath")) {
    char buff[1024];
    sprintf(buff, "classlogpath = %s", owl_global_get_classlogpath(&g));
    owl_function_makemsg(buff);
  } else if (!strcmp(variable, "typewinsize")) {
    char buff[1024];
    sprintf(buff, "typwinsize = %i", owl_global_get_typwin_lines(&g));
    owl_function_makemsg(buff);
  } else {
    /* here we should print all variables in a generic message */
    owl_function_makemsg("Unknown variable");
  }
}

void owl_command_exec(int argc, char **argv) {
  char buff[1024]; /* fix */
  int i;

  if (argc<2) {
    owl_function_makemsg("Wrong number of arguments to exec command");
    return;
  }

  strcpy(buff, "");
  for (i=1; i<argc; i++) {
    strcat(buff, argv[i]);
    strcat(buff, " ");
  }
  strcat(buff, ">/dev/null 2>/dev/null");
  system(buff);
}

void owl_command_quit() {
  owl_function_quit();
}

void owl_command_debug(int argc, char **argv) {
  if (argc<2) {
    owl_function_makemsg("Need at least one argument to debug command");
    return;
  }

  if (!owl_global_is_debug(&g)) {
    owl_function_makemsg("Debugging is not turned on");
    return;
  }

  owl_function_debugmsg(argv[1]);
}

void owl_command_ktest(int argc, char **argv) {
}

void owl_command_zlog(int argc, char **argv) {
  if (argc != 2) {
    owl_function_makemsg("Wrong number of arguments for zlog command");
    return;
  }

  if (!strcmp(argv[1], "in")) {
    owl_function_zlog_in();
  } else if (!strcmp(argv[1], "out")) {
    owl_function_zlog_out();
  } else {
    owl_function_makemsg("Invalid subcommand for zlog");
  }
}


void owl_command_zlog_out() {
  owl_function_zlog_out();
}


void owl_command_subscribe(int argc, char **argv) {
  char *recip="";

  if (argc<3) {
    owl_function_makemsg("Not enough arguments to the subscribe command");
    return;
  } else if (argc>4) {
    owl_function_makemsg("Too many arguments to the subscribe command");
    return;
  }

  if (argc==3) {
    recip="";
  } else if (argc==4) {
    recip=argv[3];
  }

  owl_function_subscribe(argv[1], argv[2], recip);
}


void owl_command_echo(int argc, char **argv) {
  int i, size;
  char *buff;

  size=0;
  for (i=1; i<argc; i++) {
    size+=strlen(argv[i])+1;
  }
  buff=malloc(size+20);
  strcpy(buff, "");
  for (i=1; i<argc; i++) {
    sprintf(buff, "%s%s ", buff, argv[i]);
  }
  buff[strlen(buff)-1]='\0';
  strcat(buff, "\n");
  owl_function_popless_text(buff);
  free(buff);
}
