#include "owl.h"
#include <stdlib.h>
#include <string.h>

void owl_fmtext_init_null(owl_fmtext *f) {
  f->textlen=0;
  f->textbuff=strdup("");
  f->fmbuff=malloc(5);
  f->fmbuff[0]=OWL_FMTEXT_ATTR_NONE;
}


void _owl_fmtext_set_attr(owl_fmtext *f, int attr, int first, int last) {
  int i;
  for (i=first; i<=last; i++) {
    f->fmbuff[i]=(unsigned char) attr;
  }
}


void owl_fmtext_append_attr(owl_fmtext *f, char *text, int attr) {
  int newlen;

  newlen=strlen(f->textbuff)+strlen(text);
  f->textbuff=realloc(f->textbuff, newlen+2);
  f->fmbuff=realloc(f->fmbuff, newlen+2);

  strcat(f->textbuff, text);
  _owl_fmtext_set_attr(f, attr, f->textlen, newlen);
  f->textlen=newlen;
}


void owl_fmtext_append_normal(owl_fmtext *f, char *text) {
  owl_fmtext_append_attr(f, text, OWL_FMTEXT_ATTR_NONE);
}


void owl_fmtext_append_bold(owl_fmtext *f, char *text) {
  owl_fmtext_append_attr(f, text, OWL_FMTEXT_ATTR_BOLD);
}


void owl_fmtext_append_reverse(owl_fmtext *f, char *text) {
  owl_fmtext_append_attr(f, text, OWL_FMTEXT_ATTR_REVERSE);
}


void owl_fmtext_append_reversebold(owl_fmtext *f, char *text) {
  owl_fmtext_append_attr(f, text, OWL_FMTEXT_ATTR_REVERSE | OWL_FMTEXT_ATTR_BOLD);
}


void owl_fmtext_addattr(owl_fmtext *f, int attr) {
  /* add the attribute to all text */
  int i, j;

  j=f->textlen;
  for (i=0; i<j; i++) {
    f->fmbuff[i] |= attr;
  }
}


void owl_fmtext_append_ztext(owl_fmtext *f, char *text) {
  int stacksize, curattrs;
  char *ptr, *txtptr, *buff, *tmpptr;
  int attrstack[32], chrstack[32];

  curattrs=OWL_FMTEXT_ATTR_NONE;
  stacksize=0;
  txtptr=text;
  while (1) {
    ptr=strpbrk(txtptr, "@{[<()>]}");
    if (!ptr) {
      /* add all the rest of the text and exit */
      owl_fmtext_append_attr(f, txtptr, curattrs);
      return;
    } else if (ptr[0]=='@') {
      /* add the text up to this point then deal with the stack */
      buff=malloc(ptr-txtptr+20);
      strncpy(buff, txtptr, ptr-txtptr);
      buff[ptr-txtptr]='\0';
      owl_fmtext_append_attr(f, buff, curattrs);
      free(buff);

      /* now the stack */
      txtptr=ptr;

      /* if we've hit our max stack depth, print the @ and move on */
      if (stacksize==32) {
	owl_fmtext_append_attr(f, "@", curattrs);
	txtptr++;
	continue;
      }

      /* if it's an @@, print an @ and continue */
      if (txtptr[1]=='@') {
	owl_fmtext_append_attr(f, "@", curattrs);
	txtptr+=2;
	continue;
      }
	
      /* if there's no opener, print the @ and continue */
      tmpptr=strpbrk(txtptr, "(<[{ ");
      if (!tmpptr || tmpptr[0]==' ') {
	owl_fmtext_append_attr(f, "@", curattrs);
	txtptr++;
	continue;
      }

      /* check what command we've got, push it on the stack, start
	 using it, and continue */
      buff=malloc(tmpptr-ptr+20);
      strncpy(buff, ptr, tmpptr-ptr);
      buff[tmpptr-ptr]='\0';
      if (!strcmp(buff, "@bold")) {
	attrstack[stacksize]=OWL_FMTEXT_ATTR_BOLD;
	chrstack[stacksize]=tmpptr[0];
	stacksize++;
	curattrs|=OWL_FMTEXT_ATTR_BOLD;
	txtptr+=6;
	free(buff);
	continue;
      } else if (!strcmp(buff, "@b")) {
	attrstack[stacksize]=OWL_FMTEXT_ATTR_BOLD;
	chrstack[stacksize]=tmpptr[0];
	stacksize++;
	curattrs|=OWL_FMTEXT_ATTR_BOLD;
	txtptr+=3;
	free(buff);
	continue;
      } else if (!strcmp(buff, "@i")) {
	attrstack[stacksize]=OWL_FMTEXT_ATTR_UNDERLINE;
	chrstack[stacksize]=tmpptr[0];
	stacksize++;
	curattrs|=OWL_FMTEXT_ATTR_UNDERLINE;
	txtptr+=3;
	free(buff);
	continue;

      } else {
	/* if we didn't understand it, we'll print it.  This is different from zwgc
	   but zwgc seems to be smarter about some screw cases than I am */
	owl_fmtext_append_attr(f, "@", curattrs);
	txtptr++;
	continue;
      }

    } else if (ptr[0]=='}' || ptr[0]==']' || ptr[0]==')' || ptr[0]=='>') {
      /* add the text up to this point first */
      buff=malloc(ptr-txtptr+20);
      strncpy(buff, txtptr, ptr-txtptr);
      buff[ptr-txtptr]='\0';
      owl_fmtext_append_attr(f, buff, curattrs);
      free(buff);

      /* now deal with the closer */
      txtptr=ptr;

      /* first, if the stack is empty we must bail (just print and go) */
      if (stacksize==0) {
	buff=malloc(5);
	buff[0]=ptr[0];
	buff[1]='\0';
	owl_fmtext_append_attr(f, buff, curattrs);
	free(buff);
	txtptr++;
	continue;
      }

      /* if the closing char is what's on the stack, turn off the
         attribue and pop the stack */
      if ((ptr[0]==')' && chrstack[stacksize-1]=='(') ||
	  (ptr[0]=='>' && chrstack[stacksize-1]=='<') ||
	  (ptr[0]==']' && chrstack[stacksize-1]=='[') ||
	  (ptr[0]=='}' && chrstack[stacksize-1]=='{')) {
	int i;
	stacksize--;
	curattrs=OWL_FMTEXT_ATTR_NONE;
	for (i=0; i<stacksize; i++) {
	  curattrs|=attrstack[i];
	}
	txtptr+=1;
	continue;
      } else {
	/* otherwise print and continue */
	buff=malloc(5);
	buff[0]=ptr[0];
	buff[1]='\0';
	owl_fmtext_append_attr(f, buff, curattrs);
	free(buff);
	txtptr++;
	continue;
      }
    } else {
      /* we've found an unattached opener, print everything and move on */
      buff=malloc(ptr-txtptr+20);
      strncpy(buff, txtptr, ptr-txtptr+1);
      buff[ptr-txtptr+1]='\0';
      owl_fmtext_append_attr(f, buff, curattrs);
      free(buff);
      txtptr=ptr+1;
      continue;
    }
  }

}

void owl_fmtext_append_fmtext(owl_fmtext *f, owl_fmtext *in, int start, int stop) {
  int newlen, i;

  newlen=strlen(f->textbuff)+(stop-start+1);
  f->textbuff=realloc(f->textbuff, newlen+1);
  f->fmbuff=realloc(f->fmbuff, newlen+1);

  strncat(f->textbuff, in->textbuff+start, stop-start+1);
  f->textbuff[newlen]='\0';
  for (i=start; i<=stop; i++) {
    f->fmbuff[f->textlen+(i-start)]=in->fmbuff[i];
  }
  f->textlen=newlen;
}


void owl_fmtext_print_plain(owl_fmtext *f, char *buff) {
  strcpy(buff, f->textbuff);
}


void owl_fmtext_curs_waddstr(owl_fmtext *f, WINDOW *w) {
  char *ptr1, *ptr2, *last;
  char *tmpbuff;

  tmpbuff=malloc(f->textlen+10);

  ptr1=f->fmbuff;
  last=f->fmbuff+f->textlen-1;
  while (ptr1<=last) {
    /* find the last char with the current fmt */
    ptr2=ptr1+owl_util_find_trans(ptr1, f->textlen-(ptr1-f->fmbuff));

    /* set the current format */
    wattrset(w, A_NORMAL);
    if (ptr1[0] & OWL_FMTEXT_ATTR_BOLD) {
      wattron(w, A_BOLD);
    }
    if (ptr1[0] & OWL_FMTEXT_ATTR_REVERSE) {
      wattron(w, A_REVERSE);
    }
    if (ptr1[0] & OWL_FMTEXT_ATTR_UNDERLINE) {
      wattron(w, A_UNDERLINE);
    }
    
    strncpy(tmpbuff, f->textbuff + (ptr1 - ((char *) (f->fmbuff))), ptr2-ptr1+1);
    tmpbuff[ptr2-ptr1+1]='\0';
    /* printf("Diff is %i\r\n", owl_util_find_trans(ptr1)); */
    waddstr(w, tmpbuff);

    ptr1=ptr2+1;
  }
  free(tmpbuff);
}


int owl_fmtext_truncate_lines(owl_fmtext *in, int aline, int lines, owl_fmtext *out) {
  /* start with line aline (where the first line is 0) and print
   *  'lines' lines
   */
  char *ptr1, *ptr2;
  int i, offset;

  /* initialize out */
  owl_fmtext_init_null(out);
  
  /* find the starting line */
  ptr1=in->textbuff;
  if (aline!=0) {
    for (i=0; i<aline; i++) {
      ptr1=strchr(ptr1, '\n');
      if (!ptr1) return(-1);
      ptr1++;
    }
  }
  /* ptr1 now holds the starting point */

  /* copy in the next 'lines' lines */
  if (lines<1) return(-1);

  for (i=0; i<lines; i++) {
    ptr2=strchr(ptr1, '\n');
    offset=ptr1-in->textbuff;
    if (!ptr2) {
      owl_fmtext_append_fmtext(out, in, offset, in->textlen-1);
      return(-1);
    }
    owl_fmtext_append_fmtext(out, in, offset, (ptr2-ptr1)+offset);
    ptr1=ptr2+1;
  }
  return(0);
}


void owl_fmtext_truncate_cols(owl_fmtext *in, int acol, int bcol, owl_fmtext *out) {
  char *ptr1, *ptr2, *last;
  int len, offset;
  
  /* the first column is column 0 */

  /* the message is expected to end in a new line for now */

  owl_fmtext_init_null(out);

  last=in->textbuff+in->textlen-1;
  ptr1=in->textbuff;
  while (ptr1<=last) {
    ptr2=strchr(ptr1, '\n');
    if (!ptr2) {
      /* but this shouldn't happen if we end in a \n */
      break;
    }
    
    if (ptr2==ptr1) {
      owl_fmtext_append_normal(out, "\n");
      ptr1++;
      continue;
    }

    /* we need to check that we won't run over here */
    len=bcol-acol;
    if (len > (ptr2-(ptr1+acol))) {
      len=ptr2-(ptr1+acol);
    }
    if (len>last-ptr1) {
      len-=(last-ptr1);
    }
    if (len<=0) {
      owl_fmtext_append_normal(out, "\n");
      ptr1=ptr2+1;
      continue;
    }

    offset=ptr1-in->textbuff;
    owl_fmtext_append_fmtext(out, in, offset+acol, offset+acol+len);

    ptr1=ptr2+1;
  }
}


int owl_fmtext_num_lines(owl_fmtext *f) {
  int lines, i;

  lines=0;
  for (i=0; f->textbuff[i]!='\0'; i++) {
    if (f->textbuff[i]=='\n') lines++;
  }

  /* if the last char wasn't a \n there's one more line */
  if (f->textbuff[i-1]!='\n') lines++;

  return(lines);
}


char *owl_fmtext_get_text(owl_fmtext *f) {
  return(f->textbuff);
}

void owl_fmtext_free(owl_fmtext *f) {
  if (f->textbuff) free(f->textbuff);
  if (f->fmbuff) free(f->fmbuff);
}


void owl_fmtext_copy(owl_fmtext *dst, owl_fmtext *src) {
  dst->textlen=src->textlen;
  dst->textbuff=malloc(src->textlen+5);
  dst->fmbuff=malloc(src->textlen+5);
  memcpy(dst->textbuff, src->textbuff, src->textlen);
  memcpy(dst->fmbuff, src->fmbuff, src->textlen);
}
