#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <termios.h>
#include <sys/ioctl.h>
#include <time.h>
#include "owl.h"

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 256
#endif

void owl_global_init(owl_global *g) {
  struct hostent *hent;
  char hostname[MAXHOSTNAMELEN];
  char buff[MAXPATHLEN];

  gethostname(hostname, MAXHOSTNAMELEN);
  hent=gethostbyname(hostname);
  if (!hent) {
    strcpy(g->thishost, "localhost");
  } else {
    strcpy(g->thishost, hent->h_name);
  }

  g->lines=LINES;
  g->cols=COLS;

  g->rightshift=0;

  owl_editwin_init(&(g->tw), NULL, g->typwinlines, g->cols, OWL_EDITWIN_STYLE_ONELINE);

  g->mode=OWL_MODE_STARTUP;
  g->curmsg=0;
  g->topmsg=0;
  g->needrefresh=1;
  owl_global_set_bell_on(g);
  owl_global_set_personalbell_off(g);
  owl_global_set_txping_on(g);
  owl_global_set_rxping_off(g);
  owl_global_set_logging_off(g);
  owl_global_set_classlogging_off(g);
  g->curmsg_vert_offset=0;
  g->resizepending=0;
  g->typwinactive=0;
  owl_global_set_typwin_lines(g, OWL_TYPWIN_SIZE);
  g->direction=OWL_DIRECTION_DOWNWARDS;
  g->zaway=0;
  g->zaway_msg=strdup(OWL_DEFAULT_ZAWAYMSG);
  g->default_zaway_msg=strdup(OWL_DEFAULT_ZAWAYMSG);
  g->zsigexec=NULL;
  g->debug=OWL_DEBUG;
  g->starttime=time(NULL); /* assumes we call init only a start time */
  strcpy(g->buffercommand, "");
  owl_global_set_startuplogin_on(g);
  owl_global_set_shutdownlogout_on(g);
  owl_global_set_loginsubs_on(g);
  owl_global_set_displayoutgoing_on(g);
  owl_global_set_config_format(g, 0);
  owl_global_set_userclue(g, OWL_USERCLUE_NONE);
  owl_global_set_summarymode_off(g);
  
  _owl_global_setup_windows(g);

  /* come back later and check passwd file first */
  strcpy(g->homedir, getenv("HOME"));

  sprintf(buff, "%s/zlog/people/", owl_global_get_homedir(g));
  owl_global_set_logpath(g, buff);
  sprintf(buff, "%s/zlog/class/", owl_global_get_homedir(g));
  owl_global_set_classlogpath(g, buff);
  

  owl_messagelist_create(&(g->msglist));
  owl_mainwin_init(&(g->mw));
  owl_popwin_init(&(g->pw));
}

void _owl_global_setup_windows(owl_global *g) {
  int lines, cols;

  lines=g->lines;
  cols=g->cols;

  /* set the new window sizes */
  g->recwinlines=g->lines-(g->typwinlines+2);

  /* create the new windows */
  g->recwin=newwin(g->recwinlines, cols, 0, 0);
  g->sepwin=newwin(1, cols, g->recwinlines, 0);
  g->msgwin=newwin(1, cols, g->recwinlines+1, 0);
  g->typwin=newwin(g->typwinlines, cols, g->recwinlines+2, 0);

  owl_editwin_set_curswin(&(g->tw), g->typwin, g->typwinlines, g->cols);

  idlok(g->typwin, FALSE);
  idlok(g->recwin, FALSE);
  idlok(g->sepwin, FALSE);
  idlok(g->msgwin, FALSE);

  nodelay(g->typwin, 1);
  keypad(g->typwin, TRUE);
  wmove(g->typwin, 0, 0);

  meta(g->typwin, TRUE);
}

int owl_global_get_mode(owl_global *g) {
  return(g->mode);
}

void owl_global_set_mode(owl_global *g, int mode) {
  g->mode=mode;
}
			 
int owl_global_get_lines(owl_global *g) {
  return(g->lines);
}

int owl_global_get_cols(owl_global *g) {
  return(g->cols);
}

int owl_global_get_typwin_lines(owl_global *g) {
  return(g->typwinlines);
}

void owl_global_set_typwin_lines(owl_global *g, int lines) {
  g->typwinlines=lines;
}

int owl_global_get_recwin_lines(owl_global *g) {
  return(g->recwinlines);
}

/* curmsg */

int owl_global_get_curmsg(owl_global *g) {
  return(g->curmsg);
}

void owl_global_set_curmsg(owl_global *g, int i) {
  g->curmsg=i;
  /* we will reset the vertical offset from here */
  /* we might want to move this out to the functions later */
  owl_global_set_curmsg_vert_offset(g, 0);
}

/* topmsg */

int owl_global_get_topmsg(owl_global *g) {
  return(g->topmsg);
}

void owl_global_set_topmsg(owl_global *g, int i) {
  g->topmsg=i;
}

/* windows */

owl_mainwin *owl_global_get_mainwin(owl_global *g) {
  return(&(g->mw));
}

owl_popwin *owl_global_get_popwin(owl_global *g) {
  return(&(g->pw));
}

/* msglist */

owl_messagelist *owl_global_get_msglist(owl_global *g) {
  return(&(g->msglist));
}

/* curses windows */

WINDOW *owl_global_get_curs_recwin(owl_global *g) {
  return(g->recwin);
}

WINDOW *owl_global_get_curs_sepwin(owl_global *g) {
  return(g->sepwin);
}

WINDOW *owl_global_get_curs_msgwin(owl_global *g) {
  return(g->msgwin);
}

WINDOW *owl_global_get_curs_typwin(owl_global *g) {
  return(g->typwin);
}

/* typwin */

owl_editwin *owl_global_get_typwin(owl_global *g) {
  return(&(g->tw));
}

/* buffercommand */

void owl_global_set_buffercommand(owl_global *g, char *command) {
  strcpy(g->buffercommand, command);
}

char *owl_global_get_buffercommand(owl_global *g) {
  return(g->buffercommand);
}

/* refresh */

int owl_global_is_needrefresh(owl_global *g) {
  if (g->needrefresh==1) return(1);
  return(0);
}

void owl_global_set_needrefresh(owl_global *g) {
  g->needrefresh=1;
}

void owl_global_set_noneedrefresh(owl_global *g) {
  g->needrefresh=0;
}

/* bell */

int owl_global_is_bell(owl_global *g) {
  if (g->bell==1) return(1);
  return(0);
}

void owl_global_set_bell_on(owl_global *g) {
  g->bell=1;
}

void owl_global_set_bell_off(owl_global *g) {
  g->bell=0;
}

/* personal bell */

int owl_global_is_personalbell(owl_global *g) {
  if (g->personalbell==1) return(1);
  return(0);
}

void owl_global_set_personalbell_on(owl_global *g) {
  g->personalbell=1;
}

void owl_global_set_personalbell_off(owl_global *g) {
  g->personalbell=0;
}


/* txping */

int owl_global_is_txping(owl_global *g) {
  if (g->txping) return(1);
  return(0);
}

void owl_global_set_txping_on(owl_global *g) {
  g->txping=1;
}

void owl_global_set_txping_off(owl_global *g) {
  g->txping=0;
}

/* rxping */

int owl_global_is_rxping(owl_global *g) {
  if (g->rxping) return(1);
  return(0);
}

void owl_global_set_rxping_on(owl_global *g) {
  g->rxping=1;
}

void owl_global_set_rxping_off(owl_global *g) {
  g->rxping=0;
}

/* rightshift */

void owl_global_set_rightshift(owl_global *g, int i) {
  g->rightshift=i;
}

int owl_global_get_rightshift(owl_global *g) {
  return(g->rightshift);
}

/* typwin */

int owl_global_is_typwin_active(owl_global *g) {
  if (g->typwinactive==1) return(1);
  return(0);
}

void owl_global_set_typwin_active(owl_global *g) {
  g->typwinactive=1;
}

void owl_global_set_typwin_inactive(owl_global *g) {
  g->typwinactive=0;
}

/* resize */

void owl_global_set_resize_pending(owl_global *g) {
  g->resizepending=1;
}

/* logging */

void owl_global_set_logging_on(owl_global *g) {
  g->logging=1;
}

void owl_global_set_logging_off(owl_global *g) {
  g->logging=0;
}

int owl_global_is_logging(owl_global *g) {
  if (g->logging==1) return(1);
  return(0);
}

void owl_global_set_classlogging_on(owl_global *g) {
  g->classlogging=1;
}

void owl_global_set_classlogging_off(owl_global *g) {
  g->classlogging=0;
}

int owl_global_is_classlogging(owl_global *g) {
  if (g->classlogging) return(1);
  return(0);
}

/* logging paths */

char *owl_global_get_logpath(owl_global *g) {
  return(g->logpath);
}

void owl_global_set_logpath(owl_global *g, char *path) {
  strcpy(g->logpath, path);
}

char *owl_global_get_classlogpath(owl_global *g) {
  return(g->classlogpath);
}

void owl_global_set_classlogpath(owl_global *g, char *path) {
  strcpy(g->classlogpath, path);
}




char *owl_global_get_homedir(owl_global *g) {
  return(g->homedir);
}

int owl_global_get_direction(owl_global *g) {
  return(g->direction);
}

void owl_global_set_direction_downwards(owl_global *g) {
  g->direction=OWL_DIRECTION_DOWNWARDS;
}

void owl_global_set_direction_upwards(owl_global *g) {
  g->direction=OWL_DIRECTION_UPWARDS;
}

/* zaway */

void owl_global_set_zaway_on(owl_global *g) {
  g->zaway=1;
}

void owl_global_set_zaway_off(owl_global *g) {
  g->zaway=0;
}

int owl_global_is_zaway(owl_global *g) {
  if (g->zaway==1) return(1);
  return(0);
}

void owl_global_set_zaway_msg(owl_global *g, char *text) {
  if (g->zaway_msg) free(g->zaway_msg);
  g->zaway_msg=strdup(text);
}

void owl_global_set_zaway_msg_default(owl_global *g) {
  owl_global_set_zaway_msg(g, owl_global_get_default_zaway_msg(g));
}

char *owl_global_get_zaway_msg(owl_global *g) {
  return(g->zaway_msg);
}

void owl_global_set_default_zaway_msg(owl_global *g, char *text) {
  if (g->default_zaway_msg) free(g->default_zaway_msg);
  g->default_zaway_msg=strdup(text);
}

char *owl_global_get_default_zaway_msg(owl_global *g) {
  return(g->default_zaway_msg);
}

/* login subs */

int owl_global_get_loginsubs(owl_global *g) {
  if (g->loginsubs) return(1);
  return(0);
}

void owl_global_set_loginsubs_on(owl_global *g) {
  g->loginsubs=1;
}

void owl_global_set_loginsubs_off(owl_global *g) {
  g->loginsubs=0;
}

/* startup login */

int owl_global_get_startuplogin(owl_global *g) {
  if (g->startuplogin) return(1);
  return(0);
}

void owl_global_set_startuplogin_on(owl_global *g) {
  g->startuplogin=1;
}

void owl_global_set_startuplogin_off(owl_global *g) {
  g->startuplogin=0;
}

/* shutdown logout */

int owl_global_get_shutdownlogout(owl_global *g) {
  if (g->shutdownlogout) return(1);
  return(0);
}

void owl_global_set_shutdownlogout_on(owl_global *g) {
  g->shutdownlogout=1;
}

void owl_global_set_shutdownlogout_off(owl_global *g) {
  g->shutdownlogout=0;
}

/* displayoutgoing */

int owl_global_get_displayoutgoing(owl_global *g) {
  if (g->displayoutgoing) return(1);
  return(0);
}

void owl_global_set_displayoutgoing_on(owl_global *g) {
  g->displayoutgoing=1;
}

void owl_global_set_displayoutgoing_off(owl_global *g) {
  g->displayoutgoing=0;
}

/* perl stuff */

void owl_global_set_perlinterp(owl_global *g, PerlInterpreter *p) {
  g->perl=p;
}

PerlInterpreter *owl_global_get_perlinterp(owl_global *g) {
  return(g->perl);
}

int owl_global_is_config_format(owl_global *g) {
  if (g->config_format) return(1);
  return(0);
}

void owl_global_set_config_format(owl_global *g, int state) {
  if (state==1) {
    g->config_format=1;
  } else {
    g->config_format=0;
  }
}


void owl_global_resize(owl_global *g) {
  struct winsize size;

  if (!g->resizepending) return;

  /* delete the current windows */
  delwin(g->recwin);
  delwin(g->sepwin);
  delwin(g->msgwin);
  delwin(g->typwin);
  if (!isendwin()) {
    endwin();
  }

  refresh();

  /* get the new size */
  ioctl(STDIN_FILENO, TIOCGWINSZ, &size);
  g->lines=size.ws_row;
  g->cols=size.ws_col;

  /* resizeterm(size.ws_row, size.ws_col); */

  /* re-initialize the windows */
  _owl_global_setup_windows(g);

  /* refresh stuff */
  g->needrefresh=1;
  owl_mainwin_redisplay(&(g->mw));
  sepbar(NULL);

  if (owl_global_is_typwin_active(g)) {
    owl_editwin_redisplay(&(g->tw), 0);
  }

  /*
    char buff[1024];
    sprintf(buff, "New size is %i lines, %i cols.\n", size.ws_row, size.ws_col);
    owl_function_makemsg(buff);
  */
  owl_function_makemsg("");

  g->resizepending=0;
}

/* zsig exec */

char *owl_global_get_zsig_exec(owl_global *g) {
  return(g->zsigexec);
}

void owl_global_set_zsig_exec(owl_global *g, char *in) {
  if (g->zsigexec) free(g->zsigexec);
  g->zsigexec=strdup(in);
}

void owl_global_set_tty(owl_global *g, char *tty) {
  if (tty) {
    strcpy(g->thistty, tty);
  } else if (getenv("DISPLAY")) {
    strcpy(g->thistty, getenv("DISPLAY"));
  } else if (ttyname(fileno(stdout))) {
    strcpy(g->thistty, ttyname(fileno(stdout)));
    if (!strncmp(g->thistty, "/dev/", 5)) {
      strcpy(g->thistty, g->thistty+5);
    }
  } else {
    strcpy(g->thistty, "unknown");
  }
    
  ZInitLocationInfo(g->thishost, g->thistty); 
}

/* debug */

void owl_global_set_debug(owl_global *g) {
  g->debug=1;
}

void owl_global_set_nodebug(owl_global *g) {
  g->debug=0;
}

int owl_global_is_debug(owl_global *g) {
  if (g->debug) return(1);
  return(0);
}

/* starttime */

time_t owl_global_get_starttime(owl_global *g) {
  return(g->starttime);
}

void owl_global_get_runtime(owl_global *g, char *buff) {
  time_t diff;

  diff=time(NULL)-owl_global_get_starttime(g);

  /* print something nicer later */   
  sprintf(buff, "%i seconds", (int) diff);
}


/* userclue */

void owl_global_set_userclue(owl_global *g, int clue) {
  g->userclue=clue;
}

void owl_global_add_userclue(owl_global *g, int clue) {
  g->userclue|=clue;
}

int owl_global_get_userclue(owl_global *g) {
  return(g->userclue);
}

int owl_global_is_userclue(owl_global *g, int clue) {
  if (g->userclue & clue) return(1);
  return(0);
}


/* summary mode */

void owl_global_set_summarymode_on(owl_global *g) {
  g->summarymode=1;
}

void owl_global_set_summarymode_off(owl_global *g) {
  g->summarymode=0;
}

int owl_global_is_summarymode(owl_global *g) {
  if (g->summarymode) return(1);
  return(0);
}

/* viewwin */

owl_viewwin *owl_global_get_viewwin(owl_global *g) {
  return(&(g->vw));
}


/* vert offset */

int owl_global_get_curmsg_vert_offset(owl_global *g) {
  return(g->curmsg_vert_offset);
}

void owl_global_set_curmsg_vert_offset(owl_global *g, int i) {
  g->curmsg_vert_offset=i;
}
