#include "owl.h"

void owl_process_key(int j) {
  WINDOW *typwin;
  owl_editwin *tw;
  
  typwin=owl_global_get_curs_typwin(&g);
  tw=owl_global_get_typwin(&g);
  
  if (j==ERR) return;

  /* first, keys that are not context sensitive */
  if (j==CTRL('z')) {
    /* suspend */
    owl_command_suspend(&g);
    return;
  } else if (j==CTRL('l')) {
    /* refresh */
    owl_function_full_redisplay();
    owl_global_set_needrefresh(&g);
    return;
  }

  /* add keys here for owl_function_typwin_grow() and
     owl_function_typwin_shrink() at some point */

  /* if the typwin is not active, use the main keybindings */
  if (!owl_global_is_typwin_active(&g)) {
    owl_function_makemsg("");
    if (j==' ') {
      owl_function_page_curmsg(10);
    } else if (j==CTRL('h') || j==127 || j==KEY_BACKSPACE || j==KEY_DC) {
      owl_function_page_curmsg(-1);
    } else if (j=='b') {
      owl_function_page_curmsg(-10);
    } else if (j=='\n' || j=='\r') {
      owl_function_page_curmsg(1);
    } else if (j=='A') {
      if (!owl_global_is_zaway(&g)) {
	owl_function_zaway_on(NULL);
      } else {
	owl_function_zaway_off();
      }
    } else if (j=='d') {
      owl_command_delete_cur();
    } else if (j=='u') {
      owl_command_undelete_curmsg();
    } else if (j=='x') {
      owl_command_expunge();
    } else if (j=='i') {
      owl_command_info();
    } else if (j=='h') {
      owl_command_help();
    } else if (j=='n') {
      owl_command_next_notdeleted();
    } else if (j=='p') {
      owl_command_prev_notdeleted();
    } else if (j==KEY_DOWN || j==CTRL('n')) {
      owl_command_next();
    } else if (j==KEY_UP || j==CTRL('p')) {
      owl_command_prev();
    } else if (j==KEY_RIGHT) {
      owl_command_shift_right();
    } else if (j==KEY_LEFT) {
      owl_command_shift_left();
    } else if (j=='<' || j==META('<')) {
      owl_global_set_rightshift(&g, 0);
      owl_command_first();
    } else if (j=='>' || j==META('>')) {
      owl_command_last();
    } else if (j==CTRL('v')) {
      owl_function_mainwin_pagedown();
    } else if (j==META('v')) {
      owl_function_mainwin_pageup();
    } else if (j=='M') {
      owl_function_curmsg_to_popwin();
    } else if (j=='w') {
      owl_function_openurl();
    } else if (j=='z') {
      /* this is ugly, do better */
      int i;
      owl_global_set_typwin_active(&g);
      owl_editwin_set_locktext(tw, "command: ");
      owl_global_set_needrefresh(&g);
      
      for (i=0; i<7; i++) {
	owl_editwin_process_char(tw, "zwrite "[i]);
      }
      wnoutrefresh(typwin);
      return;
    } else if (j=='r') {
      owl_process_command("reply");
      return;
    } else if (j==':' || j==META('x')) {
      owl_global_set_typwin_active(&g);
      owl_editwin_set_locktext(tw, "command: ");
      owl_global_set_needrefresh(&g);
      wnoutrefresh(typwin);
      return;
    } else if (j==CTRL('c')) {
      return;
    } else if (j==CTRL(META('z'))) {
      return;
    } else {
      char buff[LINE];
      if (j<META('a')) {
	sprintf(buff, "'%c (%i)' is not a valid key in this context.", j, j);
      } else if (j<META('z')) {
	sprintf(buff, "'M-%c (%i)' is not a valid key in this context.", META(j), j);
      } else {
	return;
      }
      owl_function_makemsg(buff);
      return;
    }

    sepbar(NULL);
    return;
  }

  /* otherwise keys go to the typwin */
  owl_editwin_process_char(tw, j);
  owl_global_set_needrefresh(&g);
  
  /* C-c will cancel */
  if (j==CTRL('c')) {
    owl_function_makemsg("Command cancelled.");
    owl_editwin_fullclear(tw);
    owl_global_set_needrefresh(&g);
    wnoutrefresh(typwin);
    owl_global_set_typwin_inactive(&g);
    owl_editwin_new_style(tw, OWL_EDITWIN_STYLE_ONELINE);
    return;
  }
  
  /* C-d will do whatever command if in MULTILINE mode */
  if ((owl_editwin_get_style(tw)==OWL_EDITWIN_STYLE_MULTILINE) &&
      (j==CTRL('d'))) {
    owl_function_run_buffercommand();
    owl_editwin_new_style(tw, OWL_EDITWIN_STYLE_ONELINE);
    owl_editwin_fullclear(tw);
    owl_global_set_typwin_inactive(&g);
    owl_global_set_needrefresh(&g);
    wnoutrefresh(typwin);
    return;
  }
  
  /* if we're in ONELINE mode and they hit enter, process the line */
  if ((owl_editwin_get_style(tw)==OWL_EDITWIN_STYLE_ONELINE) &&
      (j=='\n' || j=='\r')) {
    
    owl_global_set_typwin_inactive(&g);
    owl_process_command(owl_editwin_get_text(tw));
    
    /* if we're still in ONELINE mode we can clear the buffer */
    if (owl_editwin_get_style(tw)==OWL_EDITWIN_STYLE_ONELINE) {
      owl_editwin_fullclear(tw);
    }

    wnoutrefresh(typwin);
    owl_global_set_needrefresh(&g);
  }
}
