#include "owl.h"

void owl_mainwin_init(owl_mainwin *mw) {
  mw->isfull=0;
  mw->lastdisplayed=-1;
}

void owl_mainwin_redisplay(owl_mainwin *mw) {
  owl_message *m;
  int i, j, lines, x,y, savey, topmsg, curmsg, recwinlines, start;
  WINDOW *recwin;
  owl_messagelist *msglist;

  msglist=owl_global_get_msglist(&g);
  recwin=owl_global_get_curs_recwin(&g);
  topmsg=owl_global_get_topmsg(&g);
  curmsg=owl_global_get_curmsg(&g);

  werase(recwin);

  recwinlines=owl_global_get_recwin_lines(&g);
  topmsg=owl_global_get_topmsg(&g);

  /* if there are no messages, just draw a blank screen */
  if (owl_messagelist_get_size(msglist)==0) {
    owl_global_set_topmsg(&g, 0);
    werase(recwin);
    wnoutrefresh(recwin);
    owl_global_set_needrefresh(&g);
    return;
  }

  /* write the messages out */
  mw->isfull=0;
  j=owl_messagelist_get_size(msglist);
  for (i=topmsg; i<j; i++) {
    if (mw->isfull) break;
    m=owl_messagelist_get_element(msglist, i);

    /* hold on to y in case this is the current message or deleted */
    getyx(recwin, y, x);
    savey=y;

    
    /* check that we won't fill the window, and get the starting point */
    if (i==owl_global_get_curmsg(&g)) {
      start=owl_global_get_curmsg_vert_offset(&g);
      lines=owl_message_get_numlines(m)-owl_global_get_curmsg_vert_offset(&g);
    } else {
      start=0;
      lines=owl_message_get_numlines(m);
    }
    if (y+lines > recwinlines-3) {
      mw->isfull=1;
      owl_message_curs_waddstr(m, owl_global_get_curs_recwin(&g),
			       start,
			       recwinlines-y,
			       owl_global_get_rightshift(&g),
			       owl_global_get_cols(&g)+owl_global_get_rightshift(&g)-1);

    } else {
      /* print the message */
      owl_message_curs_waddstr(m, owl_global_get_curs_recwin(&g),
			       start,
			       owl_message_get_numlines(m),
			       owl_global_get_rightshift(&g),
			       owl_global_get_cols(&g)+owl_global_get_rightshift(&g)-1);
    }


    /* is it the current message and/or deleted? */
    getyx(recwin, y, x);
    wattron(recwin, A_BOLD);	
    if (owl_global_get_rightshift(&g)==0) {   /* this lame and should be fixed */
      if (m==owl_messagelist_get_element(msglist, curmsg)) {
	wmove(recwin, savey, 0);
	if (owl_global_get_curmsg_vert_offset(&g)>0) {
	  waddstr(recwin, "+");
	} else {
	  waddstr(recwin, "-");
	}
	if (!owl_message_is_delete(m)) {
	  waddstr(recwin, ">");
	} else {
	  waddstr(recwin, "D");
	}
	wmove(recwin, y, x);
      }  else if (owl_message_is_delete(m)) {
	wmove(recwin, savey, 0);
	waddstr(recwin, " D");
	wmove(recwin, y, x);
      }
    }
    wattroff(recwin, A_BOLD);
  }
  mw->lastdisplayed=i-1;

  wnoutrefresh(recwin);
  owl_global_set_needrefresh(&g);
}


int owl_mainwin_is_full(owl_mainwin *mw) {
  /* this function is broken, just turn it off for now */
  return(0);
  
  if (mw->isfull) return(1);
  return(0);
}

void owl_mainwin_calculate_topmsg(owl_mainwin *mw) {
  /* Figure out if we need to scroll (by chaning topmsg) */
  int recwinlines, y, savey, i, j, topmsg, curmsg, foo;
  owl_messagelist *msglist;

  msglist=owl_global_get_msglist(&g);
  topmsg=owl_global_get_topmsg(&g);
  curmsg=owl_global_get_curmsg(&g);
  recwinlines=owl_global_get_recwin_lines(&g);
  
  /* Find number of lines from top to bottom of curmsg (store in savey) */
  savey=0;
  for (i=topmsg; i<=curmsg; i++) {
    savey+=owl_message_get_numlines(owl_messagelist_get_element(msglist, i));
  }

  /* If our bottom line is less than 1/4 down the screen then scroll up */
  if (savey < (recwinlines / 4)) {
    y=0;
    for (j=curmsg; j>0; j--) {
      foo=owl_message_get_numlines(owl_messagelist_get_element(msglist, j));
      /* will we run the curmsg off the screen? */
      if ((foo+y) >= recwinlines) {
	j++;
	if (j>curmsg) j=curmsg;
	break;
      }
      /* have saved 1/2 the screen space? */
      y+=foo;
      if (y > (recwinlines / 2)) break;
    }
    owl_global_set_topmsg(&g, j);
    return;
  }

  /* If our bottom line is more than 3/4 down the screen then scroll down */
  if (savey > ((recwinlines * 3)/4)) {
    y=0;
    /* count lines until we can save 1/2 the screen size */
    for (j=topmsg; j<curmsg; j++) {
      y+=owl_message_get_numlines(owl_messagelist_get_element(msglist, j));
      if (y > (recwinlines / 2)) break;
    }
    if (j==curmsg) {
      j--;
    }
    owl_global_set_topmsg(&g, j+1);
    return;
  }
}

int owl_mainwin_get_last_msg(owl_mainwin *mw) {
  /* return the number of the last message displayed. -1 if none */
  return(mw->lastdisplayed);
}
