#include <zephyr/zephyr.h>
#include <curses.h>
#include <EXTERN.h>
#include <perl.h>
#include "config.h"

#define OWL_VERSION         0.10
#define OWL_VERSION_STRING "0.10"

#define OWL_DEBUG 0
#define OWL_DEBUG_FILE "/var/tmp/owldebug"

#define OWL_FMTEXT_ATTR_NONE      0
#define OWL_FMTEXT_ATTR_BOLD      1
#define OWL_FMTEXT_ATTR_REVERSE   2
#define OWL_FMTEXT_ATTR_UNDERLINE 4

#define OWL_EDITWIN_STYLE_MULTILINE 0
#define OWL_EDITWIN_STYLE_ONELINE   1

#define OWL_MESSAGE_TYPE_ADMIN  0
#define OWL_MESSAGE_TYPE_ZEPHYR 1

#define OWL_DIRECTION_NONE      0
#define OWL_DIRECTION_DOWNWARDS 1
#define OWL_DIRECTION_UPWARDS   2

#define OWL_TAB               3  /* This *HAS* to be the size of TABSTR below */
#define OWL_TABSTR        "   "
#define OWL_MSGTAB            7
#define OWL_TYPWIN_SIZE       8

#define OWL_MODE_STARTUP      1
#define OWL_MODE_READCONFIG   2
#define OWL_MODE_INTERACTIVE  3

#define OWL_USERCLUE_NONE       0
#define OWL_USERCLUE_CLASSES    1
#define OWL_USERCLUE_FOOBAR     2
#define OWL_USERCLUE_BAZ        4

#define OWL_DEFAULT_ZAWAYMSG "I'm sorry, but I am currently away from the terminal and am\nnot able to receive your message.\n"

#define CTRL(key) ((key)&037)
#define META(key) ((key)|0200)

#define LINE 2048

typedef struct _owl_fmtext {
  int textlen;
  char *textbuff;
  char *fmbuff;
} owl_fmtext;

typedef struct _owl_list {
  int size;
  int avail;
  void **list;
} owl_list;

typedef struct _owl_message {
  int type;
  ZNotice_t notice;
  owl_fmtext fmtext;
  int delete;
  char hostname[LINE];
  char sender[LINE];
  char recip[LINE];
  char class[LINE];
  char inst[LINE];
  char opcode[LINE];
  char time[LINE];
  char realm[LINE];
  char *body;
} owl_message;

typedef struct _owl_mainwin {
  int isfull;
  int lastdisplayed;
} owl_mainwin;

typedef struct _owl_editwin {
  char *buff;
  int bufflen;
  int allocated;
  int buffx, buffy;
  int topline;
  int winlines, wincols, fillcol;
  WINDOW *curswin;
  int style;
  int lock;
} owl_editwin;

typedef struct _owl_viewwin {
  owl_fmtext fmtext;
  int textlines;
  int topline;
  int rightshift;
  int winlines, wincols;
  WINDOW *curswin;
} owl_viewwin;
  
typedef struct _owl_popwin {
  WINDOW *borderwin;
  WINDOW *popwin;
  int lines;
  int cols;
  int active;
  int needsfirstrefresh;
  void (*handler) (int ch);
} owl_popwin;

typedef struct _owl_messagelist {
  owl_list list;
} owl_messagelist;

typedef struct _owl_zwrite {
  char class[LINE];
  char inst[LINE];
  char realm[LINE];
  owl_list recips;
} owl_zwrite;

typedef struct _owl_global {
  owl_mainwin mw;
  owl_popwin pw;
  int mode;
  int lines, cols;
  int curmsg, topmsg;
  int curmsg_vert_offset;
  owl_messagelist msglist;
  WINDOW *recwin, *sepwin, *msgwin, *typwin;
  int needrefresh;
  int txping, rxping;
  int bell, personalbell;
  int logging, classlogging;
  int rightshift;
  int resizepending;
  int recwinlines, typwinlines;
  int typwinactive;
  char thishost[LINE];
  char thistty[LINE];
  char homedir[LINE];
  char logpath[MAXPATHLEN];
  char classlogpath[MAXPATHLEN];
  int direction;
  int zaway;
  char *zaway_msg;
  char *default_zaway_msg;
  char *zsigexec;
  int startuplogin, shutdownlogout;
  int loginsubs;
  int displayoutgoing;
  int config_format;
  char buffercommand[1024];
  owl_editwin tw;
  owl_viewwin vw;
  PerlInterpreter *perl;
  int debug;
  int starttime;
  int userclue;
  int summarymode;
} owl_global;

/* globals */
owl_global g;

#include "owl_prototypes.h"
