/* -------------------------------- commands.c -------------------------------- */
void owl_process_command(char *buff);
void owl_command_info();
void owl_command_help();
void owl_command_version();
void owl_command_next();
void owl_command_prev();
void owl_command_next_notdeleted();
void owl_command_prev_notdeleted();
void owl_command_delete_cur();
void owl_command_undelete_curmsg();
void owl_command_expunge();
void owl_command_first();
void owl_command_last();
void owl_command_resize();
void owl_command_shift_right();
void owl_command_shift_left();
void owl_command_unsub();
void owl_command_loadsubs(int argc, char **argv);
void owl_command_zwrite_setup(char *line);
void owl_command_zwrite(char *line);
void owl_command_suspend();
void owl_command_zaway(int argc, char **argv);
void owl_command_set(int argc, char **argv);
void owl_command_print(int argc, char **argv);
void owl_command_exec(int argc, char **argv);
void owl_command_quit();
void owl_command_debug(int argc, char **argv);
void owl_command_ktest(int argc, char **argv);
void owl_command_zlog(int argc, char **argv);
void owl_command_zlog_out();
void owl_command_subscribe(int argc, char **argv);
void owl_command_echo(int argc, char **argv);

/* -------------------------------- editwin.c -------------------------------- */
void owl_editwin_init(owl_editwin *e, WINDOW *win, int winlines, int wincols, int style);
void owl_editwin_set_curswin(owl_editwin *e, WINDOW *w, int winlines, int wincols);
void owl_editwin_set_locktext(owl_editwin *e, char *text);
int owl_editwin_get_style(owl_editwin *e);
void owl_editwin_new_style(owl_editwin *e, int newstyle);
void owl_editwin_fullclear(owl_editwin *e);
void owl_editwin_clear(owl_editwin *e);
void _owl_editwin_addspace(owl_editwin *e);
void owl_editwin_redisplay(owl_editwin *e, int update);
int _owl_editwin_linewrap_word(owl_editwin *e);
void owl_editwin_insert_char(owl_editwin *e, char c);
void owl_editwin_overwrite_char(owl_editwin *e, char c);
void owl_editwin_delete_char(owl_editwin *e);
void owl_editwin_insert_string(owl_editwin *e, char *string);
void owl_editwin_overwrite_string(owl_editwin *e, char *string);
int _owl_editwin_get_index_from_xy(owl_editwin *e);
void _owl_editwin_set_xy_by_index(owl_editwin *e, int index);
void owl_editwin_adjust_for_locktext(owl_editwin *e);
void owl_editwin_backspace(owl_editwin *e);
void owl_editwin_key_up(owl_editwin *e);
void owl_editwin_key_down(owl_editwin *e);
void owl_editwin_key_left(owl_editwin *e);
void owl_editwin_key_right(owl_editwin *e);
void owl_editwin_move_to_nextword(owl_editwin *e);
void owl_editwin_move_to_previousword(owl_editwin *e);
void owl_editwin_delete_nextword(owl_editwin *e);
void owl_editwin_delete_to_endofline(owl_editwin *e);
void owl_editwin_move_to_end(owl_editwin *e);
void owl_editwin_move_to_top(owl_editwin *e);
void owl_editwin_fill_paragraph(owl_editwin *e);
void owl_editwin_process_char(owl_editwin *e, int j);
char *owl_editwin_get_text(owl_editwin *e);
int owl_editwin_get_numchars_on_line(owl_editwin *e, int line);
int owl_editwin_get_numlines(owl_editwin *e);

/* -------------------------------- fmtext.c -------------------------------- */
void owl_fmtext_init_null(owl_fmtext *f);
void _owl_fmtext_set_attr(owl_fmtext *f, int attr, int first, int last);
void owl_fmtext_append_attr(owl_fmtext *f, char *text, int attr);
void owl_fmtext_append_normal(owl_fmtext *f, char *text);
void owl_fmtext_append_bold(owl_fmtext *f, char *text);
void owl_fmtext_append_reverse(owl_fmtext *f, char *text);
void owl_fmtext_append_reversebold(owl_fmtext *f, char *text);
void owl_fmtext_addattr(owl_fmtext *f, int attr);
void owl_fmtext_append_ztext(owl_fmtext *f, char *text);
void owl_fmtext_append_fmtext(owl_fmtext *f, owl_fmtext *in, int start, int stop);
void owl_fmtext_print_plain(owl_fmtext *f, char *buff);
void owl_fmtext_curs_waddstr(owl_fmtext *f, WINDOW *w);
int owl_fmtext_truncate_lines(owl_fmtext *in, int aline, int lines, owl_fmtext *out);
void owl_fmtext_truncate_cols(owl_fmtext *in, int acol, int bcol, owl_fmtext *out);
int owl_fmtext_num_lines(owl_fmtext *f);
char *owl_fmtext_get_text(owl_fmtext *f);
void owl_fmtext_free(owl_fmtext *f);
void owl_fmtext_copy(owl_fmtext *dst, owl_fmtext *src);

/* -------------------------------- functions.c -------------------------------- */
void owl_function_adminmsg(char *header, char *body);
void owl_function_nextmsg();
void owl_function_prevmsg();
void owl_function_nextmsg_notdeleted();
void owl_function_prevmsg_notdeleted();
void owl_function_deletecur();
void owl_function_undeletecur();
void owl_function_expunge();
void owl_function_firstmsg();
void owl_function_lastmsg();
void owl_function_shift_right();
void owl_function_shift_left();
void owl_function_unsub();
void owl_function_loadsubs(char *file);
void owl_function_suspend();
void owl_function_zaway_on(char *msg);
void owl_function_zaway_off();
void owl_function_quit();
void owl_function_zlog_in();
void owl_function_zlog_out();
void owl_function_makemsg(char *in);
void owl_function_openurl();
void owl_function_calculate_topmsg(int direction);
void owl_function_resize();
void owl_function_run_buffercommand();
void owl_function_debugmsg(char *in);
void owl_function_refresh();
void owl_function_beep();
void owl_function_subscribe(char *class, char *inst, char *recip);
void owl_function_set_cursor(WINDOW *win);
void owl_function_full_redisplay();
void owl_function_popless_text(char *text);
void owl_function_popless_fmtext(owl_fmtext *fm);
void owl_function_help();
void owl_function_info();
void owl_function_curmsg_to_popwin();
void owl_function_page_curmsg(int step);
void owl_function_resize_typwin(int newsize);
void owl_function_typwin_grow();
void owl_function_typwin_shrink();
void owl_function_mainwin_pagedown();
void owl_function_mainwin_pageup();

/* -------------------------------- global.c -------------------------------- */
void owl_global_init(owl_global *g);
void _owl_global_setup_windows(owl_global *g);
int owl_global_get_mode(owl_global *g);
void owl_global_set_mode(owl_global *g, int mode);
int owl_global_get_lines(owl_global *g);
int owl_global_get_cols(owl_global *g);
int owl_global_get_typwin_lines(owl_global *g);
void owl_global_set_typwin_lines(owl_global *g, int lines);
int owl_global_get_recwin_lines(owl_global *g);
int owl_global_get_curmsg(owl_global *g);
void owl_global_set_curmsg(owl_global *g, int i);
int owl_global_get_topmsg(owl_global *g);
void owl_global_set_topmsg(owl_global *g, int i);
owl_mainwin *owl_global_get_mainwin(owl_global *g);
owl_popwin *owl_global_get_popwin(owl_global *g);
owl_messagelist *owl_global_get_msglist(owl_global *g);
WINDOW *owl_global_get_curs_recwin(owl_global *g);
WINDOW *owl_global_get_curs_sepwin(owl_global *g);
WINDOW *owl_global_get_curs_msgwin(owl_global *g);
WINDOW *owl_global_get_curs_typwin(owl_global *g);
owl_editwin *owl_global_get_typwin(owl_global *g);
void owl_global_set_buffercommand(owl_global *g, char *command);
char *owl_global_get_buffercommand(owl_global *g);
int owl_global_is_needrefresh(owl_global *g);
void owl_global_set_needrefresh(owl_global *g);
void owl_global_set_noneedrefresh(owl_global *g);
int owl_global_is_bell(owl_global *g);
void owl_global_set_bell_on(owl_global *g);
void owl_global_set_bell_off(owl_global *g);
int owl_global_is_personalbell(owl_global *g);
void owl_global_set_personalbell_on(owl_global *g);
void owl_global_set_personalbell_off(owl_global *g);
int owl_global_is_txping(owl_global *g);
void owl_global_set_txping_on(owl_global *g);
void owl_global_set_txping_off(owl_global *g);
int owl_global_is_rxping(owl_global *g);
void owl_global_set_rxping_on(owl_global *g);
void owl_global_set_rxping_off(owl_global *g);
void owl_global_set_rightshift(owl_global *g, int i);
int owl_global_get_rightshift(owl_global *g);
int owl_global_is_typwin_active(owl_global *g);
void owl_global_set_typwin_active(owl_global *g);
void owl_global_set_typwin_inactive(owl_global *g);
void owl_global_set_resize_pending(owl_global *g);
void owl_global_set_logging_on(owl_global *g);
void owl_global_set_logging_off(owl_global *g);
int owl_global_is_logging(owl_global *g);
void owl_global_set_classlogging_on(owl_global *g);
void owl_global_set_classlogging_off(owl_global *g);
int owl_global_is_classlogging(owl_global *g);
char *owl_global_get_logpath(owl_global *g);
void owl_global_set_logpath(owl_global *g, char *path);
char *owl_global_get_classlogpath(owl_global *g);
void owl_global_set_classlogpath(owl_global *g, char *path);
char *owl_global_get_homedir(owl_global *g);
int owl_global_get_direction(owl_global *g);
void owl_global_set_direction_downwards(owl_global *g);
void owl_global_set_direction_upwards(owl_global *g);
void owl_global_set_zaway_on(owl_global *g);
void owl_global_set_zaway_off(owl_global *g);
int owl_global_is_zaway(owl_global *g);
void owl_global_set_zaway_msg(owl_global *g, char *text);
void owl_global_set_zaway_msg_default(owl_global *g);
char *owl_global_get_zaway_msg(owl_global *g);
void owl_global_set_default_zaway_msg(owl_global *g, char *text);
char *owl_global_get_default_zaway_msg(owl_global *g);
int owl_global_get_loginsubs(owl_global *g);
void owl_global_set_loginsubs_on(owl_global *g);
void owl_global_set_loginsubs_off(owl_global *g);
int owl_global_get_startuplogin(owl_global *g);
void owl_global_set_startuplogin_on(owl_global *g);
void owl_global_set_startuplogin_off(owl_global *g);
int owl_global_get_shutdownlogout(owl_global *g);
void owl_global_set_shutdownlogout_on(owl_global *g);
void owl_global_set_shutdownlogout_off(owl_global *g);
int owl_global_get_displayoutgoing(owl_global *g);
void owl_global_set_displayoutgoing_on(owl_global *g);
void owl_global_set_displayoutgoing_off(owl_global *g);
void owl_global_set_perlinterp(owl_global *g, PerlInterpreter *p);
PerlInterpreter *owl_global_get_perlinterp(owl_global *g);
int owl_global_is_config_format(owl_global *g);
void owl_global_set_config_format(owl_global *g, int state);
void owl_global_resize(owl_global *g);
char *owl_global_get_zsig_exec(owl_global *g);
void owl_global_set_zsig_exec(owl_global *g, char *in);
void owl_global_set_tty(owl_global *g, char *tty);
void owl_global_set_debug(owl_global *g);
void owl_global_set_nodebug(owl_global *g);
int owl_global_is_debug(owl_global *g);
time_t owl_global_get_starttime(owl_global *g);
void owl_global_get_runtime(owl_global *g, char *buff);
void owl_global_set_userclue(owl_global *g, int clue);
void owl_global_add_userclue(owl_global *g, int clue);
int owl_global_get_userclue(owl_global *g);
int owl_global_is_userclue(owl_global *g, int clue);
void owl_global_set_summarymode_on(owl_global *g);
void owl_global_set_summarymode_off(owl_global *g);
int owl_global_is_summarymode(owl_global *g);
owl_viewwin *owl_global_get_viewwin(owl_global *g);
int owl_global_get_curmsg_vert_offset(owl_global *g);
void owl_global_set_curmsg_vert_offset(owl_global *g, int i);

/* -------------------------------- keys.c -------------------------------- */
void owl_process_key(int j);

/* -------------------------------- list.c -------------------------------- */
int owl_list_create(owl_list *l);
int owl_list_get_size(owl_list *l);
void *owl_list_get_element(owl_list *l, int n);
int owl_list_append_element(owl_list *l, void *element);
int owl_list_remove_element(owl_list *l, int n);
void owl_list_free_all(owl_list *l, void (*elefree)(void *));
void owl_list_free_simple(owl_list *l);

/* -------------------------------- logging.c -------------------------------- */
void owl_log_outgoing(char *to, char *text);
void owl_log_incoming(owl_message *m);

/* -------------------------------- mainwin.c -------------------------------- */
void owl_mainwin_init(owl_mainwin *mw);
void owl_mainwin_redisplay(owl_mainwin *mw);
int owl_mainwin_is_full(owl_mainwin *mw);
void owl_mainwin_calculate_topmsg(owl_mainwin *mw);
int owl_mainwin_get_last_msg(owl_mainwin *mw);

/* -------------------------------- message.c -------------------------------- */
void owl_message_create_admin(owl_message *m, char *header, char *text);
void owl_message_create_from_zephyr(owl_message *m, ZNotice_t *n);
void _owl_message_make_text_from_config(owl_message *m);
void _owl_message_make_text_from_notice(owl_message *m);
void _owl_message_get_zsig(owl_message *m, char *buff, int size);
int owl_message_get_numlines(owl_message *m);
void owl_message_mark_delete(owl_message *m);
void owl_message_unmark_delete(owl_message *m);
int owl_message_is_delete(owl_message *m);
void owl_message_print_header(owl_message *m, WINDOW *w);
ZNotice_t *owl_message_get_notice(owl_message *m);
void owl_message_free(owl_message *m);
char *owl_message_get_hostname(owl_message *m);
void owl_message_curs_waddstr(owl_message *m, WINDOW *win, int aline, int bline, int acol, int bcol);
owl_fmtext *owl_message_get_fmtext(owl_message *m);
void owl_message_set_class(owl_message *m, char *class);
char *owl_message_get_class(owl_message *m);
void owl_message_set_instance(owl_message *m, char *inst);
char *owl_message_get_instance(owl_message *m);
void owl_message_set_sender(owl_message *m, char *sender);
char *owl_message_get_sender(owl_message *m);
void owl_message_set_recipient(owl_message *m, char *recip);
char *owl_message_get_recipient(owl_message *m);
void owl_message_set_realm(owl_message *m, char *realm);
char *owl_message_get_realm(owl_message *m);
void owl_message_set_opcode(owl_message *m, char *opcode);
char *owl_message_get_opcode(owl_message *m);
char *owl_message_get_timestr(owl_message *m);
int owl_message_is_admin(owl_message *m);
int owl_message_is_zephyr(owl_message *m);
char *owl_message_get_text(owl_message *m);
char *owl_message_get_body(owl_message *m);
int owl_message_is_personal(owl_message *m);
int owl_message_is_private(owl_message *m);
int owl_message_is_mail(owl_message *m);

/* -------------------------------- messagelist.c -------------------------------- */
int owl_messagelist_create(owl_messagelist *ml);
int owl_messagelist_get_size(owl_messagelist *ml);
int owl_messagelist_get_numdeleted(owl_messagelist *ml);
void *owl_messagelist_get_element(owl_messagelist *ml, int n);
int owl_messagelist_append_element(owl_messagelist *ml, void *element);
int owl_messagelist_delete_element(owl_messagelist *ml, int n);
int owl_messagelist_undelete_element(owl_messagelist *ml, int n);
int owl_messagelist_expunge(owl_messagelist *ml);

/* -------------------------------- owl.c -------------------------------- */
int main(int argc, char **argv, char **env);
void sig_handler(int sig);
void usage();

/* -------------------------------- popwin.c -------------------------------- */
int owl_popwin_init(owl_popwin *pw);
int owl_popwin_up(owl_popwin *pw);
int owl_popwin_display_text(owl_popwin *pw, char *text);
int owl_popwin_getch(owl_popwin *pw);
int owl_popwin_close(owl_popwin *pw);
int owl_popwin_is_active(owl_popwin *pw);
int owl_popwin_refresh(owl_popwin *pw);
void owl_popwin_set_handler(owl_popwin *pw, void (*func)(int ch));
void owl_popwin_unset_handler(owl_popwin *pw);
WINDOW *owl_popwin_get_curswin(owl_popwin *pw);
int owl_popwin_get_lines(owl_popwin *pw);
int owl_popwin_get_cols(owl_popwin *pw);
int owl_popwin_needs_first_refresh(owl_popwin *pw);
void owl_popwin_no_needs_first_refresh(owl_popwin *pw);

/* -------------------------------- readconfig.c -------------------------------- */
void owl_readconfig(char *file);
void owl_config_execute(char *line);
char *owl_config_getmsg(owl_message *m);

/* -------------------------------- tester.c -------------------------------- */
void screeninit();
void test1();
void test2(char *in);
void test3();
void test4();
void test5();
int main(int argc, char **argv, char **env);

/* -------------------------------- text.c -------------------------------- */
void owl_text_format(char *out, char *in, int linelen);
int owl_text_truncate_lines(char *out, char *in, int aline, int lines);
void owl_text_truncate_cols(char *out, char *in, int acol, int bcol);
void owl_text_indent(char *out, char *in, int n);
int owl_text_num_lines(char *in);

/* -------------------------------- util.c -------------------------------- */
void sepbar(char *in);
void pophandler_quit(int ch);
void pophandler_viewwin(int ch);
char **atokenize(char *buffer, char *sep, int *i);
char **owl_parseline_old(char *line, int *argc);
void owl_parsefree(char **argv, int argc);
char **owl_parseline(char *line, int *argc);
int owl_util_find_trans(char *in, int len);
void downstr(char *foo);

/* -------------------------------- viewwin.c -------------------------------- */
void owl_viewwin_init_text(owl_viewwin *v, WINDOW *win, int winlines, int wincols, char *text);
void owl_viewwin_init_fmtext(owl_viewwin *v, WINDOW *win, int winlines, int wincols, owl_fmtext *fmtext);
void owl_viewwin_set_curswin(owl_viewwin *v, WINDOW *w, int winlines, int wincols);
void owl_viewwin_redisplay(owl_viewwin *v, int update);
void owl_viewwin_pagedown(owl_viewwin *v);
void owl_viewwin_linedown(owl_viewwin *v);
void owl_viewwin_pageup(owl_viewwin *v);
void owl_viewwin_lineup(owl_viewwin *v);
void owl_viewwin_right(owl_viewwin *v, int n);
void owl_viewwin_left(owl_viewwin *v, int n);
void owl_viewwin_free(owl_viewwin *v);
void owl_viewwin_process_key(owl_viewwin *v, int j);

/* -------------------------------- zephyr.c -------------------------------- */
int loadsubs(char *filename);
int loadloginsubs(char *filename);
void unsuball();
int owl_zephyr_sub(char *class, char *inst, char *recip);
void zlog_in();
void zlog_out();
char *owl_zephyr_get_field(ZNotice_t *n, int j, int *k);
int owl_zephyr_get_num_fields(ZNotice_t *n);
char *owl_zephyr_get_message(ZNotice_t *n, int *k);
char *owl_zephyr_get_zsig(ZNotice_t *n, int *k);
void send_zephyr(char *opcode, char *zsig, char *class, char *instance, char *recipient, char *message);
void send_ping(char *to);
void owl_zephyr_handle_ack(ZNotice_t *retnotice);
int owl_zephyr_notice_is_ack(ZNotice_t *n);
void owl_zephyr_zaway(owl_message *m);
void owl_zephyr_hackaway_cr(ZNotice_t *n);
void owl_zephyr_zlocate(char *user, char *out, int auth);

/* -------------------------------- zwrite.c -------------------------------- */
int owl_zwrite_create_from_line(owl_zwrite *z, char *line);
void owl_zwrite_send_ping(owl_zwrite *z);
void owl_zwrite_send_message(owl_zwrite *z, char *msg);
char *owl_zwrite_get_class(owl_zwrite *z);
char *owl_zwrite_get_instance(owl_zwrite *z);
char *owl_zwrite_get_realm(owl_zwrite *z);
void owl_zwrite_get_recipstr(owl_zwrite *z, char *buff);
int owl_zwrite_is_personal(owl_zwrite *z);
void owl_zwrite_free(owl_zwrite *z);

