#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "owl.h"

void owl_readconfig(char *file) {
  PerlInterpreter *p;
  char buff[1024], filename[1024];
  char *embedding[] = { "", "-e", "0" };

  if (file==NULL) {
    sprintf(filename, "%s/%s", getenv("HOME"), ".owlconf");
  } else {
    strcpy(filename, file);
  }

  /* create and initialize interpreter */
  p=perl_alloc();
  owl_global_set_perlinterp(&g, p);
  
  perl_construct(p);
  perl_parse(p, NULL, 3, embedding, NULL);
  perl_run(p);

  /* create variables */
  perl_get_sv("owl::class", TRUE);
  perl_get_sv("owl::instance", TRUE);
  perl_get_sv("owl::recipient", TRUE);
  perl_get_sv("owl::sender", TRUE);
  perl_get_sv("owl::opcode", TRUE);
  perl_get_sv("owl::zsig", TRUE);
  perl_get_sv("owl::msg", TRUE);
  perl_get_sv("owl::time", TRUE);
  perl_get_sv("owl::host", TRUE);
  perl_get_av("owl::fields", TRUE);
  
  /* load in owl_command() */
  strcpy(buff, "sub owl::command {                            \n");
  strcat(buff, "  my $command = shift;                       \n");
  strcat(buff, "  push @owl::commands, $command;  \n");
  strcat(buff, "}                                            \n");
  perl_eval_pv(buff, FALSE);

  /* load in the config file */
  perl_require_pv(filename);

  /* check if we have the formatting function */
  if (perl_get_cv("owl::format_msg", FALSE)) {
    owl_global_set_config_format(&g, 1);
  }
}


void owl_config_execute(char *line) {
  STRLEN n_a;
  SV *command;
  AV *commands;
  int numcommands, i;

  /* execute the subroutine */
  perl_eval_pv(line, FALSE);

  /* execute all the commands, cleaning up the arrays as we go */
  commands=perl_get_av("owl::commands", TRUE);
  numcommands=av_len(commands)+1;
  for (i=0; i<numcommands; i++) {
    command=av_shift(commands);
    owl_process_command(SvPV(command, n_a));
  }
  av_undef(commands);
}

char *owl_config_getmsg(owl_message *m) {
  /* caller is responsbile for freeing the returned string */
  STRLEN n_a;
  SV *command, *response;
  AV *commands;
  int numcommands, i, j, len;
  char *ptr, *ptr2, *out;
  ZNotice_t *n;

  /* set owl::msg */
  n=owl_message_get_notice(m);
  ptr=owl_zephyr_get_message(n, &len);
  ptr2=malloc(len+20);
  memcpy(ptr2, ptr, len);
  ptr2[len]='\0';
  if (ptr2[len-1]!='\n') {
    strcat(ptr2, "\n");
  }
  sv_setpv(perl_get_sv("owl::msg", TRUE), ptr2);
  free(ptr2);

  /* set owl::zsig */
  ptr=owl_zephyr_get_zsig(n, &len);
  if (len>0) {
    ptr2=malloc(len+20);
    memcpy(ptr2, ptr, len);
    ptr2[len]='\0';
    if (ptr2[len-1]=='\n') {  /* do we really need this? */
      ptr2[len-1]='\0';
    }
    sv_setpv(perl_get_sv("owl::zsig", TRUE), ptr2);
    free(ptr2);
  } else {
    sv_setpv(perl_get_sv("owl::zsig", TRUE), "");
  }

  /* set owl::type */
  if (owl_message_is_zephyr(m)) {
    sv_setpv(perl_get_sv("owl::type", TRUE), "zephyr");
  } else if (owl_message_is_admin(m)) {
    sv_setpv(perl_get_sv("owl::type", TRUE), "admin");
  } else {
    sv_setpv(perl_get_sv("owl::type", TRUE), "unknown");
  }

  /* set everything else */
  sv_setpv(perl_get_sv("owl::class", TRUE), owl_message_get_class(m));
  sv_setpv(perl_get_sv("owl::instance", TRUE), owl_message_get_instance(m));
  sv_setpv(perl_get_sv("owl::sender", TRUE), owl_message_get_sender(m));
  sv_setpv(perl_get_sv("owl::recipient", TRUE), owl_message_get_recipient(m));
  sv_setpv(perl_get_sv("owl::opcode", TRUE), owl_message_get_opcode(m));
  sv_setpv(perl_get_sv("owl::time", TRUE), owl_message_get_timestr(m));
  sv_setpv(perl_get_sv("owl::host", TRUE), owl_message_get_hostname(m));

  /* free old @fields ? */
  /* I don't think I need to do this, but ask marc to make sure */
  /*
  j=av_len(perl_get_av("fields", TRUE));
  for (i=0; i<j; i++) {
    tmpsv=av_pop(perl_get_av("fields", TRUE));
    SvREFCNT_dec(tmpsv);
  }
  */

  /* set owl::fields */
  av_clear(perl_get_av("fields", TRUE));
  j=owl_zephyr_get_num_fields(n);
  for (i=0; i<j; i++) {
    ptr=strdup(owl_zephyr_get_field(n, i+1, &len)); /* shouldn't use strdup here */
    ptr[len]='\0';
    av_push(perl_get_av("fields", TRUE), newSVpvn(ptr, len));
    free(ptr);
  }
  
  /* eval owl::formag_msg() */
  response=perl_eval_pv("owl::format_msg();", FALSE);
  out=strdup(SvPV(response, n_a));
  if (out[strlen(out)-1]!='\n') {
    strcat(out, "\n");
  }

  /* deal with commands executed */
  commands=perl_get_av("owl::commands", TRUE);
  numcommands=av_len(commands)+1;
  for (i=0; i<numcommands; i++) {
    command=av_shift(commands);
    owl_process_command(SvPV(command, n_a));
  }
  av_undef(commands);
  return(out);
}
