#include "owl.h"
#include <unistd.h>

void screeninit() {
  char buff[1024];
  
  sprintf(buff, "TERMINFO=%s", TERMINFO);
  putenv(buff);

  initscr();
  /* cbreak(); */
  raw();
  noecho();
  intrflush(stdscr,FALSE);
  keypad(stdscr,TRUE);
  nodelay(stdscr,1);
  clear();
  refresh();
  meta(stdscr, TRUE);
}

void test1() {
  int j;
  owl_editwin e;

  screeninit();

  owl_editwin_init(&e, stdscr, LINES, COLS, OWL_EDITWIN_STYLE_MULTILINE);
  while (1) {
    usleep(100);

    j=getch();

    if (j==ERR) continue;

    if (j==3) break;

    if (j==27) {
      j=getch();
      if (j==ERR) continue;
      owl_editwin_process_char(&e, j);
    } else {
      owl_editwin_process_char(&e, j);
    }
  }
  endwin();
  printf("Had:\n%s", owl_editwin_get_text(&e));
}

void test2(char *in) {
  owl_fmtext t;

  screeninit();

  owl_fmtext_init_null(&t);
  owl_fmtext_append_ztext(&t, in);
  owl_fmtext_curs_waddstr(&t, stdscr);
  wrefresh(stdscr);
  sleep(5000);
  endwin();
}

void test3() {
  ZNotice_t *n;

  printf("%i\n", sizeof(n->z_uid.zuid_addr));
  /* gethostbyaddr((char *) &(n->z_uid.zuid_addr), sizeof(n->z_uid.zuid_addr), AF_INET); */
}

void test4() {
  int j;
  char buff[1024];

  screeninit();
  
  while (1) {
    usleep(100);

    j=getch();

    if (j==ERR) continue;

    if (j==3) break;
    sprintf(buff, "%o\n", j);
    addstr(buff);
  }
  endwin();
}

void test5() {
  owl_viewwin v;
  int j;

  screeninit();

  owl_viewwin_init(&v, stdscr, LINES, COLS, "1\n2\n3\n4\n5\n6\n7\n8\n9\n10\n11\n12\n13\n14\n15\n");
  owl_viewwin_redisplay(&v, 1);

  while (1) {
    usleep(100);
    
    j=getch();

    if (j==ERR) continue;
    if (j==3) break;

    owl_viewwin_process_key(&v, j);
    doupdate();
  }
  endwin();
}
  

int main(int argc, char **argv, char **env) {
  test5();
  return(0);
}

