#include "owl.h"
#include <stdlib.h>
#include <string.h>

void sepbar(char *in) {
  char buff[1024];
  WINDOW *sepwin;
  owl_messagelist *ml;
  int x, y;

  sepwin=owl_global_get_curs_sepwin(&g);
  ml=owl_global_get_msglist(&g);

  werase(sepwin);
  wattron(sepwin, A_REVERSE);
  whline(sepwin, ACS_HLINE, owl_global_get_cols(&g));

  wmove(sepwin, 0, 2);  

  if (owl_messagelist_get_size(ml)==0) {
    strcpy(buff, " (-/-) ");
  } else {
    sprintf(buff, " (%i/%i) ", owl_global_get_curmsg(&g)+1, owl_messagelist_get_size(ml));
  }
  waddstr(sepwin, buff);


  if (owl_mainwin_is_full(owl_global_get_mainwin(&g))) {
    getyx(sepwin, y, x);
    wmove(sepwin, y, x+2);
    wattron(sepwin, A_BOLD);
    waddstr(sepwin, " <more> ");
    wattroff(sepwin, A_BOLD);
  }

  if (owl_global_get_rightshift(&g)>0) {
    getyx(sepwin, y, x);
    wmove(sepwin, y, x+2);
    sprintf(buff, " right: %i ", owl_global_get_rightshift(&g));
    waddstr(sepwin, buff);
  }

  if (owl_global_is_zaway(&g)) {
    getyx(sepwin, y, x);
    wmove(sepwin, y, x+2);
    wattron(sepwin, A_BOLD);
    wattroff(sepwin, A_REVERSE);
    waddstr(sepwin, " ZAWAY ");
    wattron(sepwin, A_REVERSE);
    wattroff(sepwin, A_BOLD);
  }

  if (in) {
    getyx(sepwin, y, x);
    wmove(sepwin, y, x+2);
    waddstr(sepwin, in);
  }

  getyx(sepwin, y, x);
  wmove(sepwin, y, owl_global_get_cols(&g)-1);
    
  wattroff(sepwin, A_BOLD);
  wattroff(sepwin, A_REVERSE);
  wnoutrefresh(sepwin);
}


void pophandler_quit(int ch) {
  if (ch=='q') {
    owl_popwin_close(owl_global_get_popwin(&g));
  }
}


void pophandler_viewwin(int ch) {
  owl_viewwin *v;

  v=owl_global_get_viewwin(&g);

  if (ch=='q') {
    owl_popwin_close(owl_global_get_popwin(&g));
    owl_viewwin_free(v);
    return;
  }

  owl_viewwin_process_key(v, ch);
  owl_global_set_needrefresh(&g);
}


char **atokenize(char *buffer, char *sep, int *i) {
  /* each element of return must be freed by user */
  char **args;
  char *workbuff, *foo;
  int done=0, first=1, count=0;

  workbuff=malloc(strlen(buffer)+1);
  memcpy(workbuff, buffer, strlen(buffer)+1);

  args=NULL;
  while (!done) {
    if (first) {
      first=0;
      foo=(char *)strtok(workbuff, sep);
    } else {
      foo=(char *)strtok(NULL, sep);
    }
    if (foo==NULL) {
      done=1;
    } else {
      args=(char **)realloc(args, sizeof(char *) * (count+1));
      args[count]=malloc(strlen(foo)+1);
      strcpy(args[count], foo);
      count++;
    }
  }
  *i=count;
  free(workbuff);
  return(args);
}

char **owl_parseline_old(char *line, int *argc) {
  char *ptr1, *ptr2;
  int count, len, foo;
  char **argv=NULL;
  
  /* Break a command line up into argv, argc.  It should
   *  deal with quotes etc.
   */

  /* This is a simple version for now with out all the functionality */

  /* set ptr1 to first non space chr */
  len=strlen(line);
  if (line[0]==' ') {
    ptr1=strrchr(line, ' ')+1;
    if (ptr1>=line+len) {
      *argc=0;
      return(argv);
    }
  } else {
    ptr1=line;
  }
  
  count=0;
  ptr2=ptr1;
  while (1) {
    foo=strcspn(ptr1, " \t\n");
    argv=realloc(argv, ((count+1)*sizeof(char *))+20);
    argv[count]=malloc(foo+3);
    strncpy(argv[count], ptr1, foo);
    argv[count][foo]='\0';
    count++;

    ptr1+=foo;
    foo=strspn(ptr1, " \t\n");
    if (!foo) break;
    ptr1+=foo;

    if (ptr1 >= line+len) break;
  }

  *argc=count;
  return(argv);
}


void owl_parsefree(char **argv, int argc) {
  int i;

  if (!argv) return;
  
  for (i=0; i<argc; i++) {
    if (argv[i]) free(argv[i]);
  }
  free(argv);
}

char **owl_parseline(char *line, int *argc) {
  /* break a command line up into argv, argc.  The caller must free
     the returned values.  If there is an error argc will be set to
     -1, argv will be NULL and the caller does not need to free
     anything */

  char **argv;
  int i, len, between=1;
  char *curarg;
  char quote;

  argv=malloc(sizeof(char *));
  len=strlen(line);
  curarg=malloc(len+10);
  strcpy(curarg, "");
  quote='\0';
  *argc=0;
  for (i=0; i<len+1; i++) {
    /* find the first real character */
    if (between) {
      if (line[i]==' ' || line[i]=='\t') {
	continue;
      } else {
	between=0;
	i--;
	continue;
      }
    }

    /* deal with a quote character */
    if (line[i]=='"' || line[i]=="'"[0]) {
      /* if this type of quote is open, close it */
      if (quote==line[i]) {
	quote='\0';
	continue;
      }

      /* if nothing is open then open with this */
      if (quote=='\0') {
	quote=line[i];
	continue;
      }

      /* if another type of quote is open then treat this as a literal */
      curarg[strlen(curarg)+1]='\0';
      curarg[strlen(curarg)]=line[i];
      continue;
    }

    /* if it's not a space or end of command */
    if (line[i]!=' ' && line[i]!='\t' && line[i]!='\n' && line[i]!='\0') {
      curarg[strlen(curarg)+1]='\0';
      curarg[strlen(curarg)]=line[i];
      continue;
    }

    /* if it's the end of the command and our quotes are unblanaced we should complain */

    /* if we're not in quotes, add the argument */
    if (quote=='\0') {
      /* add the argument */
      argv=realloc(argv, sizeof(char *)*((*argc)+1));
      argv[*argc]=malloc(strlen(curarg)+2);
      strcpy(argv[*argc], curarg);
      *argc=*argc+1;
      strcpy(curarg, "");
      between=1;
      continue;
    }

    /* if it is a space and we're in quotes */
    curarg[strlen(curarg)+1]='\0';
    curarg[strlen(curarg)]=line[i];
  }

  if (quote!='\0') {
    owl_parsefree(argv, *argc);
    *argc=-1;
    return(NULL);
  }

  return(argv);
}



int owl_util_find_trans(char *in, int len) {
  int i;
  for (i=1; i<len; i++) {
    if (in[i] != in[0]) return(i-1);
  }
  return(i);
}


void downstr(char *foo) {
  int i;
  for (i=0; foo[i]!=0; i++) {
    foo[i]=tolower(foo[i]);
  }
}
