/* -------------------------------- aim.c -------------------------------- */
extern void owl_aim_init(void);
extern int owl_aim_login(char *screenname, char *password);
#if 0
#endif
extern void owl_aim_successful_login(char *screenname);
extern void owl_aim_logout(void);
extern void owl_aim_login_error(char *message);
extern int owl_aim_send_im(char *to, char *msg);
extern void owl_aim_addbuddy(char *name);
extern void owl_aim_delbuddy(char *name);
#if 0
extern void owl_aim_get_idle(char *screenname);
#endif
extern void owl_aim_chat_join(char *chatroom);
extern void owl_aim_chat_leave(char *chatroom);
extern int owl_aim_chat_sendmsg(char *chatroom, char *msg);
extern char *owl_aim_normalize_screenname(char *in);
extern int owl_aim_process_events();
extern int faimtest_flapversion(aim_session_t *sess, aim_frame_t *fr, ...);
#if 0
#endif
extern int faimtest_conncomplete(aim_session_t *sess, aim_frame_t *fr, ...);
extern void addcb_bos(aim_session_t *sess, aim_conn_t *bosconn);
extern int login(aim_session_t *sess, const char *sn, const char *passwd);
extern int logout(aim_session_t *sess);
#if 0
#endif
extern int faimtest_parse_genericerr(aim_session_t *sess, aim_frame_t *fr, ...);
extern void chatnav_redirect(aim_session_t *sess, struct aim_redirect_data *redir);
extern void chat_redirect(aim_session_t *sess, struct aim_redirect_data *redir);

/* -------------------------------- buddy.c -------------------------------- */
extern void owl_buddy_create(owl_buddy *b, int proto, char *name);
extern char *owl_buddy_get_name(owl_buddy *b);
extern int owl_buddy_is_idle(owl_buddy *b);
extern void owl_buddy_set_idle(owl_buddy *b);
extern void owl_buddy_set_unidle(owl_buddy *b);
extern int owl_buddy_get_proto(owl_buddy *b);
extern int owl_buddy_is_proto_aim(owl_buddy *b);
extern void owl_buddy_set_idle_since(owl_buddy *b, int diff);
extern int owl_buddy_get_idle_time(owl_buddy *b);
extern void owl_buddy_free(owl_buddy *b);

/* -------------------------------- buddylist.c -------------------------------- */
extern void owl_buddylist_init(owl_buddylist *bl);
extern void owl_buddylist_add_aim_buddy(owl_buddylist *bl, char *screenname);
extern int owl_buddylist_remove_aim_buddy(owl_buddylist *bl, char *name);
extern void owl_buddylist_oncoming(owl_buddylist *bl, char *screenname);
extern void owl_buddylist_offgoing(owl_buddylist *bl, char *screenname);
extern int owl_buddylist_get_size(owl_buddylist *bl);
extern owl_buddy *owl_buddylist_get_buddy_n(owl_buddylist *bl, int index);
extern owl_buddy *owl_buddylist_get_aim_buddy(owl_buddylist *bl, char *name);
extern int owl_buddylist_is_aim_buddy_loggedin(owl_buddylist *bl, char *screenname);
extern void owl_buddylist_clear(owl_buddylist *bl);
extern void owl_buddylist_free(owl_buddylist *bl);

/* -------------------------------- cmd.c -------------------------------- */
extern int owl_cmddict_setup(owl_cmddict *cd);
extern int owl_cmddict_init(owl_cmddict *cd);
extern int owl_cmddict_add_from_list(owl_cmddict *cd, owl_cmd *cmds);
extern void owl_cmddict_get_names(owl_cmddict *d, owl_list *l);
extern owl_cmd *owl_cmddict_find(owl_cmddict *d, char *name);
extern void owl_cmddict_namelist_free(owl_list *l);
extern int owl_cmddict_add_alias(owl_cmddict *cd, char *alias_from, char *alias_to);
extern char *owl_cmddict_execute(owl_cmddict *cd, owl_context *ctx, char *cmdbuff);
extern int owl_cmd_create_from_template(owl_cmd *cmd, owl_cmd *templ);
extern int owl_cmd_create_alias(owl_cmd *cmd, char *name, char *aliased_to);
extern void owl_cmd_free(owl_cmd *cmd);
extern int owl_cmd_is_context_valid(owl_cmd *cmd, owl_context *ctx); 
extern char *owl_cmd_execute(owl_cmd *cmd, owl_cmddict *cd, owl_context *ctx, int argc, char **argv, char *cmdbuff);
extern char *owl_cmd_get_summary(owl_cmd *cmd);
extern char *owl_cmd_describe(owl_cmd *cmd);
extern void owl_cmd_get_help(owl_cmddict *d, char *name, owl_fmtext *fm);

/* -------------------------------- commands.c -------------------------------- */
extern void owl_command_info();
extern void owl_command_nop();
extern char *owl_command_help(int argc, char **argv, char *buff);
extern char *owl_command_zlist(int argc, char **argv, char *buff);
extern char *owl_command_alist();
extern char *owl_command_blist();
extern char *owl_command_toggleoneline();
extern void owl_command_about();
extern void owl_command_version();
extern char *owl_command_addbuddy(int argc, char **argv, char *buff);
extern char *owl_command_delbuddy(int argc, char **argv, char *buff);
extern char *owl_command_startup(int argc, char **argv, char *buff);
extern char *owl_command_unstartup(int argc, char **argv, char *buff);
extern char *owl_command_dump(int argc, char **argv, char *buff);
extern char *owl_command_source(int argc, char **argv, char *buff);
extern char *owl_command_next(int argc, char **argv, char *buff);
extern char *owl_command_prev(int argc, char **argv, char *buff);
extern char *owl_command_smartnarrow(int argc, char **argv, char *buff);
extern char *owl_command_smartfilter(int argc, char **argv, char *buff);
extern void owl_command_expunge();
extern void owl_command_first();
extern void owl_command_last();
extern void owl_command_resize();
extern void owl_command_redisplay();
extern void owl_command_shift_right();
extern void owl_command_shift_left();
extern void owl_command_unsuball();
extern char *owl_command_loadsubs(int argc, char **argv, char *buff);
extern char *owl_command_loadloginsubs(int argc, char **argv, char *buff);
extern void owl_command_suspend();
extern char *owl_command_start_command(int argc, char **argv, char *buff);
extern char *owl_command_start_question(int argc, char **argv, char *buff);
extern char *owl_command_start_password(int argc, char **argv, char *buff);
extern char *owl_command_zaway(int argc, char **argv, char *buff);
extern char *owl_command_set(int argc, char **argv, char *buff);
extern char *owl_command_unset(int argc, char **argv, char *buff);
extern char *owl_command_print(int argc, char **argv, char *buff);
extern char *owl_command_exec(int argc, char **argv, char *buff);
extern char *owl_command_pexec(int argc, char **argv, char *buff);
extern char *owl_command_aexec(int argc, char **argv, char *buff);
extern char *owl_command_perl(int argc, char **argv, char *buff);
extern char *owl_command_pperl(int argc, char **argv, char *buff);
extern char *owl_command_aperl(int argc, char **argv, char *buff);
extern char *owl_command_multi(int argc, char **argv, char *buff);
extern char *owl_command_alias(int argc, char **argv, char *buff);
extern char *owl_command_bindkey(int argc, char **argv, char *buff);
extern char *owl_command_style(int argc, char **argv, char *buff);
extern void owl_command_quit();
extern char *owl_command_debug(int argc, char **argv, char *buff);
extern char *owl_command_term(int argc, char **argv, char *buff);
extern char *owl_command_zlog(int argc, char **argv, char *buff);
extern void owl_command_zlog_out(void);
extern char *owl_command_subscribe(int argc, char **argv, char *buff);
extern char *owl_command_unsubscribe(int argc, char **argv, char *buff);
extern char *owl_command_echo(int argc, char **argv, char *buff);
extern void owl_command_getsubs(void);
extern void owl_command_status(void);
extern char *owl_command_zwrite(int argc, char **argv, char *buff);
extern char *owl_command_aimwrite(int argc, char **argv, char *buff);
extern char *owl_command_zcrypt(int argc, char **argv, char *buff);
#ifdef OWL_ENABLE_ZCRYPT
#else
#endif
extern char *owl_command_reply(int argc, char **argv, char *buff);
extern char *owl_command_filter(int argc, char **argv, char *buff);
extern char *owl_command_zlocate(int argc, char **argv, char *buff);
extern char *owl_command_view(int argc, char **argv, char *buff);
extern char *owl_command_show(int argc, char **argv, char *buff);
extern char *owl_command_viewclass(int argc, char **argv, char *buff);
extern char *owl_command_viewuser(int argc, char **argv, char *buff);
extern void owl_command_pop_message(void);
extern void owl_command_openurl(void);
extern char *owl_command_delete(int argc, char **argv, char *buff);
extern char *owl_command_undelete(int argc, char **argv, char *buff);
extern void owl_command_beep();
extern char *owl_command_colorview(int argc, char **argv, char *buff);
extern char *owl_command_zpunt(int argc, char **argv, char *buff);
extern char *owl_command_zunpunt(int argc, char **argv, char *buff);
extern void owl_command_zpunt_and_zunpunt(int argc, char **argv, int type);
extern char *owl_command_smartzpunt(int argc, char **argv, char *buff);
extern char *owl_command_getview(int argc, char **argv, char *buff);
extern char *owl_command_getvar(int argc, char **argv, char *buff);
extern char *owl_command_search(int argc, char **argv, char *buff);
extern char *owl_command_aimlogin(int argc, char **argv, char *buff);
extern char *owl_command_aimlogout(int argc, char **argv, char *buff);
extern void owl_command_edit_cancel(owl_editwin *e);
extern void owl_command_edit_history_prev(owl_editwin *e);
extern void owl_command_edit_history_next(owl_editwin *e);
extern char *owl_command_edit_insert_text(owl_editwin *e, int argc, char **argv, char *buff);
extern void owl_command_editline_done(owl_editwin *e);
extern void owl_command_editresponse_done(owl_editwin *e);
extern void owl_command_editmulti_done(owl_editwin *e);
extern void owl_command_editmulti_done_or_delete(owl_editwin *e);
extern void owl_command_popless_quit(owl_viewwin *vw);

/* -------------------------------- context.c -------------------------------- */
extern int owl_context_init(owl_context *ctx);
extern int owl_context_matches(owl_context *ctx, int test);
extern void *owl_context_get_data(owl_context *ctx);
extern int owl_context_get_mode(owl_context *ctx);
extern int owl_context_get_active(owl_context *ctx);
extern int owl_context_is_startup(owl_context *ctx);
extern int owl_context_is_interactive(owl_context *ctx);
extern void owl_context_set_startup(owl_context *ctx);
extern void owl_context_set_readconfig(owl_context *ctx);
extern void owl_context_set_interactive(owl_context *ctx);
extern void owl_context_set_popless(owl_context *ctx, owl_viewwin *vw);
extern void owl_context_set_recv(owl_context *ctx);
extern void owl_context_set_editmulti(owl_context *ctx, owl_editwin *ew);
extern void owl_context_set_editline(owl_context *ctx, owl_editwin *ew);
extern void owl_context_set_editresponse(owl_context *ctx, owl_editwin *ew);

/* -------------------------------- dict.c -------------------------------- */
extern int owl_dict_create(owl_dict *d);
extern int owl_dict_get_size(owl_dict *d);
extern int _owl_dict_find_pos(owl_dict *d, char *k, int *pos);
extern void *owl_dict_find_element(owl_dict *d, char *k);
extern int owl_dict_get_keys(owl_dict *d, owl_list *l);
extern void owl_dict_noop_free(void *x);
extern int owl_dict_insert_element(owl_dict *d, char *k, void *v, void (*free_on_replace)(void *old));
extern void *owl_dict_remove_element(owl_dict *d, char *k);
extern void owl_dict_free_all(owl_dict *d, void (*elefree)(void *));
extern void owl_dict_free_simple(owl_dict *d);
#ifdef OWL_INCLUDE_REG_TESTS
extern int owl_dict_regtest(void);
#endif /* OWL_INCLUDE_REG_TESTS */

/* -------------------------------- editwin.c -------------------------------- */
extern void owl_editwin_init(owl_editwin *e, WINDOW *win, int winlines, int wincols, int style, owl_history *hist);
extern void owl_editwin_set_curswin(owl_editwin *e, WINDOW *w, int winlines, int wincols);
extern void owl_editwin_set_echochar(owl_editwin *e, int ch);
extern WINDOW *owl_editwin_get_curswin(owl_editwin *e);
extern void owl_editwin_set_history(owl_editwin *e, owl_history *h);
extern owl_history *owl_editwin_get_history(owl_editwin *e);
extern void owl_editwin_set_dotsend(owl_editwin *e);
extern int owl_editwin_limit_maxcols(int v, int maxv);
extern void owl_editwin_set_locktext(owl_editwin *e, char *text);
extern int owl_editwin_get_style(owl_editwin *e);
extern void owl_editwin_new_style(owl_editwin *e, int newstyle, owl_history *h);
extern void owl_editwin_fullclear(owl_editwin *e);
extern void owl_editwin_clear(owl_editwin *e);
extern void _owl_editwin_addspace(owl_editwin *e);
extern void owl_editwin_recenter(owl_editwin *e);
extern void owl_editwin_redisplay(owl_editwin *e, int update);
extern int _owl_editwin_linewrap_word(owl_editwin *e);
extern void owl_editwin_insert_char(owl_editwin *e, char c);
extern void owl_editwin_overwrite_char(owl_editwin *e, char c);
extern void owl_editwin_delete_char(owl_editwin *e);
extern void owl_editwin_transpose_chars(owl_editwin *e);
extern void owl_editwin_insert_string(owl_editwin *e, char *string);
extern void owl_editwin_overwrite_string(owl_editwin *e, char *string);
extern int _owl_editwin_get_index_from_xy(owl_editwin *e);
extern void _owl_editwin_set_xy_by_index(owl_editwin *e, int index);
extern void owl_editwin_adjust_for_locktext(owl_editwin *e);
extern void owl_editwin_backspace(owl_editwin *e);
extern void owl_editwin_key_up(owl_editwin *e);
extern void owl_editwin_key_down(owl_editwin *e);
extern void owl_editwin_key_left(owl_editwin *e);
extern void owl_editwin_key_right(owl_editwin *e);
extern void owl_editwin_move_to_nextword(owl_editwin *e);
extern void owl_editwin_move_to_previousword(owl_editwin *e);
extern void owl_editwin_delete_nextword(owl_editwin *e);
extern void owl_editwin_delete_previousword(owl_editwin *e);
extern void owl_editwin_delete_to_endofline(owl_editwin *e);
extern void owl_editwin_move_to_line_end(owl_editwin *e);
extern void owl_editwin_move_to_line_start(owl_editwin *e);
extern void owl_editwin_move_to_end(owl_editwin *e);
extern void owl_editwin_move_to_top(owl_editwin *e);
extern void owl_editwin_fill_paragraph(owl_editwin *e);
extern int owl_editwin_is_at_end(owl_editwin *e);
extern int owl_editwin_check_dotsend(owl_editwin *e);
extern void owl_editwin_post_process_char(owl_editwin *e, int j);
extern void owl_editwin_process_char(owl_editwin *e, int j);
extern char *owl_editwin_get_text(owl_editwin *e);
extern int owl_editwin_get_numchars_on_line(owl_editwin *e, int line);
extern int owl_editwin_get_numlines(owl_editwin *e);

/* -------------------------------- filter.c -------------------------------- */
extern int owl_filter_init_fromstring(owl_filter *f, char *name, char *string);
extern int owl_filter_init(owl_filter *f, char *name, int argc, char **argv);
extern char *owl_filter_get_name(owl_filter *f);
extern void owl_filter_set_polarity_match(owl_filter *f);
extern void owl_filter_set_polarity_unmatch(owl_filter *f);
extern void owl_filter_set_color(owl_filter *f, int color);
extern int owl_filter_get_color(owl_filter *f);
extern void owl_filter_set_cachedmsgid(owl_filter *f, int cachedmsgid);
extern int owl_filter_get_cachedmsgid(owl_filter *f);
extern int owl_filter_message_match(owl_filter *f, owl_message *m);
extern int _owl_filter_message_match_recurse(owl_filter *f, owl_message *m, owl_list *fes, int start, int end);
extern void owl_filter_print(owl_filter *f, char *out);
extern int owl_filter_equiv(owl_filter *a, owl_filter *b);
extern void owl_filter_free(owl_filter *f);

/* -------------------------------- filterelement.c -------------------------------- */
extern void owl_filterelement_create_null(owl_filterelement *fe);
extern void owl_filterelement_create_openbrace(owl_filterelement *fe);
extern void owl_filterelement_create_closebrace(owl_filterelement *fe);
extern void owl_filterelement_create_and(owl_filterelement *fe);
extern void owl_filterelement_create_or(owl_filterelement *fe);
extern void owl_filterelement_create_not(owl_filterelement *fe);
extern void owl_filterelement_create_true(owl_filterelement *fe);
extern void owl_filterelement_create_false(owl_filterelement *fe);
extern void owl_filterelement_create_re(owl_filterelement *fe, char *field, char *re);
extern void owl_filterelement_free(owl_filterelement *fe);
extern int owl_filterelement_is_null(owl_filterelement *fe);
extern int owl_filterelement_is_openbrace(owl_filterelement *fe);
extern int owl_filterelement_is_closebrace(owl_filterelement *fe);
extern int owl_filterelement_is_and(owl_filterelement *fe);
extern int owl_filterelement_is_or(owl_filterelement *fe);
extern int owl_filterelement_is_not(owl_filterelement *fe);
extern int owl_filterelement_is_true(owl_filterelement *fe);
extern int owl_filterelement_is_false(owl_filterelement *fe);
extern int owl_filterelement_is_re(owl_filterelement *fe);
extern owl_regex *owl_filterelement_get_re(owl_filterelement *fe);
extern char *owl_filterelement_get_field(owl_filterelement *fe);
extern int owl_filterelement_is_value(owl_filterelement *fe);
extern char *owl_filterelement_to_string(owl_filterelement *fe);

/* -------------------------------- fmtext.c -------------------------------- */
extern void owl_fmtext_init_null(owl_fmtext *f);
extern void _owl_fmtext_set_attr(owl_fmtext *f, int attr, int first, int last);
extern void _owl_fmtext_add_attr(owl_fmtext *f, int attr, int first, int last);
extern void _owl_fmtext_set_color(owl_fmtext *f, int color, int first, int last);
extern void owl_fmtext_append_attr(owl_fmtext *f, char *text, int attr, int color);
extern void owl_fmtext_append_normal(owl_fmtext *f, char *text);
extern void owl_fmtext_append_normal_color(owl_fmtext *f, char *text, int color);
extern void owl_fmtext_append_bold(owl_fmtext *f, char *text);
extern void owl_fmtext_append_reverse(owl_fmtext *f, char *text);
extern void owl_fmtext_append_reversebold(owl_fmtext *f, char *text);
extern void owl_fmtext_addattr(owl_fmtext *f, int attr);
extern void owl_fmtext_colorize(owl_fmtext *f, int color);
extern void owl_fmtext_append_ztext(owl_fmtext *f, char *text);
extern void _owl_fmtext_append_fmtext(owl_fmtext *f, owl_fmtext *in, int start, int stop);
extern void owl_fmtext_append_fmtext(owl_fmtext *f, owl_fmtext *in);
extern void owl_fmtext_append_spaces(owl_fmtext *f, int nspaces);
extern void owl_fmtext_append_list(owl_fmtext *f, owl_list *l, char *join_with, char *(format_fn)(void*));
extern char *owl_fmtext_print_plain(owl_fmtext *f);
extern void owl_fmtext_curs_waddstr(owl_fmtext *f, WINDOW *w);
extern int owl_fmtext_truncate_lines(owl_fmtext *in, int aline, int lines, owl_fmtext *out);
extern void owl_fmtext_truncate_cols(owl_fmtext *in, int acol, int bcol, owl_fmtext *out);
extern int owl_fmtext_num_lines(owl_fmtext *f);
extern char *owl_fmtext_get_text(owl_fmtext *f);
extern void owl_fmtext_set_char(owl_fmtext *f, int index, int ch);
extern void owl_fmtext_free(owl_fmtext *f);
extern void owl_fmtext_copy(owl_fmtext *dst, owl_fmtext *src);
extern int owl_fmtext_search_and_highlight(owl_fmtext *f, char *string);
extern int owl_fmtext_search(owl_fmtext *f, char *string);

/* -------------------------------- functions.c -------------------------------- */
extern void owl_function_noop(void);
extern char *owl_function_command(char *cmdbuff);
extern void owl_function_command_norv(char *cmdbuff);
extern void owl_function_command_alias(char *alias_from, char *alias_to);
extern owl_cmd *owl_function_get_cmd(char *name);
extern void owl_function_show_commands();
extern void owl_function_show_view(char *viewname);
extern void owl_function_show_styles();
extern char *owl_function_style_describe(void *name);
extern char *owl_function_cmd_describe(void *name);
extern void owl_function_show_command(char *name);
extern void owl_function_adminmsg(char *header, char *body);
extern void owl_function_make_outgoing_zephyr(char *body, char *zwriteline, char *zsig);
extern int owl_function_make_outgoing_aim(char *body, char *to);
extern void owl_function_zwrite_setup(char *line);
extern void owl_function_aimwrite_setup(char *line);
extern void owl_function_zwrite(char *line, char *msg);
extern void owl_function_zcrypt(char *line, char *msg);
#ifdef OWL_ENABLE_ZCRYPT
#endif
#ifdef OWL_ENABLE_ZCRYPT
#else
#endif
extern void owl_function_aimwrite(char *to);
extern void owl_function_nextmsg_full(char *filter, int skip_deleted, int last_if_none);
extern void owl_function_prevmsg_full(char *filter, int skip_deleted, int first_if_none);
extern void owl_function_nextmsg();
extern void owl_function_prevmsg();
extern void owl_function_nextmsg_notdeleted();
extern void owl_function_prevmsg_notdeleted();
extern void owl_function_nextmsg_personal();
extern void owl_function_prevmsg_personal();
extern void owl_function_deletecur(int move_after);
extern void owl_function_undeletecur(int move_after);
extern void owl_function_expunge();
extern void owl_function_firstmsg();
extern void owl_function_lastmsg_noredisplay();
extern void owl_function_lastmsg();
extern void owl_function_shift_right();
extern void owl_function_shift_left();
extern void owl_function_unsuball();
extern void owl_function_loadsubs(char *file);
extern void owl_function_loadloginsubs(char *file);
extern void owl_function_suspend();
extern void owl_function_zaway_toggle();
extern void owl_function_zaway_on();
extern void owl_function_zaway_off();
extern void owl_function_quit();
extern void owl_function_makemsg(char *fmt, ...);
extern void owl_function_errormsg(char *fmt, ...);
extern void owl_function_openurl();
extern void owl_function_calculate_topmsg(int direction);
extern int owl_function_calculate_topmsg_top(int direction, owl_view *v, int curmsg, int topmsg, int recwinlines);
extern int owl_function_calculate_topmsg_neartop(int direction, owl_view *v, int curmsg, int topmsg, int recwinlines);
extern int owl_function_calculate_topmsg_center(int direction, owl_view *v, int curmsg, int topmsg, int recwinlines);
extern int owl_function_calculate_topmsg_paged(int direction, owl_view *v, int curmsg, int topmsg, int recwinlines, int center_on_page);
extern int owl_function_calculate_topmsg_normal(int direction, owl_view *v, int curmsg, int topmsg, int recwinlines);
extern void owl_function_resize();
extern void owl_function_run_buffercommand();
extern void owl_function_debugmsg(char *fmt, ...);
extern void owl_function_refresh();
extern void owl_function_beep();
extern void owl_function_subscribe(char *class, char *inst, char *recip);
extern void owl_function_unsubscribe(char *class, char *inst, char *recip);
extern void owl_function_set_cursor(WINDOW *win);
extern void owl_function_full_redisplay();
extern void owl_function_popless_text(char *text);
extern void owl_function_popless_fmtext(owl_fmtext *fm);
extern void owl_function_about();
extern void owl_function_info();
#ifdef HAVE_LIBZEPHYR
#endif
#ifdef HAVE_LIBZEPHYR
#endif    
extern void owl_function_curmsg_to_popwin();
extern void owl_function_page_curmsg(int step);
extern void owl_function_resize_typwin(int newsize);
extern void owl_function_typwin_grow();
extern void owl_function_typwin_shrink();
extern void owl_function_mainwin_pagedown();
extern void owl_function_mainwin_pageup();
extern void owl_function_getsubs();
extern void owl_function_printallvars();
extern void owl_function_show_variables();
extern void owl_function_show_variable(char *name);
extern void owl_function_delete_by_id(int id, int flag);
extern void owl_function_delete_automsgs();
extern void owl_function_status();
extern void owl_function_show_term();
extern void owl_function_reply(int type, int enter);
extern void owl_function_zlocate(int argc, char **argv, int auth);
extern void owl_function_start_command(char *line);
extern void owl_function_start_question(char *line);
extern void owl_function_start_password(char *line);
extern char *owl_function_exec(int argc, char **argv, char *buff, int type);
extern char *owl_function_perl(int argc, char **argv, char *buff, int type);
#if 0
extern void owl_function_change_view_old(char *filtname);
#endif
extern void owl_function_change_view(char *filtname);
extern void owl_function_create_filter(int argc, char **argv);
extern void owl_function_show_filters();
extern void owl_function_show_filter(char *name);
extern void owl_function_show_zpunts();
extern char *owl_function_classinstfilt(char *class, char *instance);
extern char *owl_function_zuserfilt(char *user);
extern char *owl_function_aimuserfilt(char *user);
extern char *owl_function_typefilt(char *type);
extern void owl_function_delete_curview_msgs(int flag);
extern char *owl_function_smartfilter(int type);
extern void owl_function_smartzpunt(int type);
extern void owl_function_color_current_filter(char *color);
extern void owl_function_show_colors();
extern void owl_function_zpunt(char *class, char *inst, char *recip, int direction);
extern void owl_function_activate_keymap(char *keymap);
extern void owl_function_show_keymaps();
extern char *owl_function_keymap_summary(void *name);
extern void owl_function_show_keymap(char *name);
extern void owl_function_help_for_command(char *cmdname);
extern void owl_function_search_start(char *string, int direction);
extern void owl_function_search_continue(int direction);
extern void owl_function_search_helper(int mode, int direction);
extern char *owl_function_ztext_stylestrip(char *zt);
extern void owl_function_buddylist(int aim, int zephyr, char *file);
#ifdef HAVE_LIBZEPHYR
#endif
#ifdef HAVE_LIBZEPHYR
#endif
extern void owl_function_dump(char *filename);
extern void owl_function_do_newmsgproc(void);
extern void owl_function_xterm_raise(void);
extern void owl_function_xterm_deiconify(void);
extern void owl_function_addstartup(char *buff);
extern void owl_function_delstartup(char *buff);
extern void owl_function_source(char *filename);
extern void owl_function_change_style(owl_view *v, char *stylename);
extern void owl_function_toggleoneline();

/* -------------------------------- global.c -------------------------------- */
#ifndef MAXHOSTNAMELEN
#endif
extern void owl_global_init(owl_global *g);
extern void _owl_global_setup_windows(owl_global *g);
extern owl_context *owl_global_get_context(owl_global *g);
extern int owl_global_get_lines(owl_global *g);
extern int owl_global_get_cols(owl_global *g);
extern int owl_global_get_recwin_lines(owl_global *g);
extern int owl_global_get_curmsg(owl_global *g);
extern void owl_global_set_curmsg(owl_global *g, int i);
extern int owl_global_get_topmsg(owl_global *g);
extern void owl_global_set_topmsg(owl_global *g, int i);
extern owl_mainwin *owl_global_get_mainwin(owl_global *g);
extern owl_popwin *owl_global_get_popwin(owl_global *g);
extern owl_messagelist *owl_global_get_msglist(owl_global *g);
extern owl_keyhandler *owl_global_get_keyhandler(owl_global *g);
extern WINDOW *owl_global_get_curs_recwin(owl_global *g);
extern WINDOW *owl_global_get_curs_sepwin(owl_global *g);
extern WINDOW *owl_global_get_curs_msgwin(owl_global *g);
extern WINDOW *owl_global_get_curs_typwin(owl_global *g);
extern owl_editwin *owl_global_get_typwin(owl_global *g);
extern void owl_global_set_buffercommand(owl_global *g, char *command);
extern char *owl_global_get_buffercommand(owl_global *g);
extern int owl_global_is_needrefresh(owl_global *g);
extern void owl_global_set_needrefresh(owl_global *g);
extern void owl_global_set_noneedrefresh(owl_global *g);
extern owl_vardict *owl_global_get_vardict(owl_global *g);
extern owl_cmddict *owl_global_get_cmddict(owl_global *g);
extern void owl_global_set_rightshift(owl_global *g, int i);
extern int owl_global_get_rightshift(owl_global *g);
extern int owl_global_is_typwin_active(owl_global *g);
extern void owl_global_set_typwin_active(owl_global *g);
extern void owl_global_set_typwin_inactive(owl_global *g);
extern void owl_global_set_resize_pending(owl_global *g);
extern char *owl_global_get_homedir(owl_global *g);
extern int owl_global_get_direction(owl_global *g);
extern void owl_global_set_direction_downwards(owl_global *g);
extern void owl_global_set_direction_upwards(owl_global *g);
extern void owl_global_set_perlinterp(owl_global *g, void *p);
extern void *owl_global_get_perlinterp(owl_global *g);
extern int owl_global_is_config_format(owl_global *g);
extern void owl_global_set_config_format(owl_global *g, int state);
extern void owl_global_set_have_config(owl_global *g);
extern void owl_global_set_no_have_config(owl_global *g);
extern int owl_global_have_config(owl_global *g);
extern void owl_global_resize(owl_global *g, int x, int y);
extern int owl_global_is_debug_fast(owl_global *g);
extern time_t owl_global_get_starttime(owl_global *g);
extern time_t owl_global_get_runtime(owl_global *g);
extern void owl_global_get_runtime_string(owl_global *g, char *buff);
extern char *owl_global_get_hostname(owl_global *g);
extern void owl_global_set_userclue(owl_global *g, int clue);
extern void owl_global_add_userclue(owl_global *g, int clue);
extern int owl_global_get_userclue(owl_global *g);
extern int owl_global_is_userclue(owl_global *g, int clue);
extern owl_viewwin *owl_global_get_viewwin(owl_global *g);
extern int owl_global_get_curmsg_vert_offset(owl_global *g);
extern void owl_global_set_curmsg_vert_offset(owl_global *g, int i);
extern void owl_global_set_startupargs(owl_global *g, int argc, char **argv);
extern char *owl_global_get_startupargs(owl_global *g);
extern owl_history *owl_global_get_msg_history(owl_global *g);
extern owl_history *owl_global_get_cmd_history(owl_global *g);
extern owl_list *owl_global_get_filterlist(owl_global *g);
extern owl_filter *owl_global_get_filter(owl_global *g, char *name);
extern void owl_global_add_filter(owl_global *g, owl_filter *f);
extern void owl_global_remove_filter(owl_global *g, char *name);
extern int owl_global_get_nextmsgid(owl_global *g);
extern owl_view *owl_global_get_current_view(owl_global *g);
extern owl_filterelement *owl_global_get_filterelement_true(owl_global *g);
extern owl_filterelement *owl_global_get_filterelement_false(owl_global *g);
extern owl_filterelement *owl_global_get_filterelement_null(owl_global *g);
extern int owl_global_get_hascolors(owl_global *g);
extern int owl_global_get_colorpairs(owl_global *g);
extern owl_list *owl_global_get_puntlist(owl_global *g);
extern int owl_global_message_is_puntable(owl_global *g, owl_message *m);
extern int owl_global_should_followlast(owl_global *g);
extern int owl_global_is_search_active(owl_global *g);
extern void owl_global_set_search_active(owl_global *g, char *string);
extern void owl_global_set_search_inactive(owl_global *g);
extern char *owl_global_get_search_string(owl_global *g);
extern void owl_global_set_newmsgproc_pid(owl_global *g, int i);
extern int owl_global_get_newmsgproc_pid(owl_global *g);
extern void owl_global_add_to_malloced(owl_global *g, int i);
extern void owl_global_add_to_freed(owl_global *g, int i);
extern int owl_global_get_malloced(owl_global *g);
extern int owl_global_get_freed(owl_global *g);
extern int owl_global_get_meminuse(owl_global *g);
extern int owl_global_is_aimloggedin(owl_global *g);
extern char *owl_global_get_aim_screenname(owl_global *g);
extern void owl_global_set_aimloggedin(owl_global *g, char *screenname);
extern void owl_global_set_aimnologgedin(owl_global *g);
extern int owl_global_is_doaimevents(owl_global *g);
extern void owl_global_set_doaimevents(owl_global *g);
extern void owl_global_set_no_doaimevents(owl_global *g);
extern aim_session_t *owl_global_get_aimsess(owl_global *g);
extern aim_conn_t *owl_global_get_waitingconn(owl_global *g);
extern int owl_global_is_aimnop_time(owl_global *g);
extern void owl_global_aimnop_sent(owl_global *g);
extern owl_timer *owl_global_get_aim_login_timer(owl_global *g);
extern void owl_global_messagequeue_addmsg(owl_global *g, owl_message *m);
extern owl_message *owl_global_messageuque_popmsg(owl_global *g);
extern int owl_global_messagequeue_pending(owl_global *g);
extern owl_buddylist *owl_global_get_buddylist(owl_global *g);
extern owl_style *owl_global_get_style_by_name(owl_global *g, char *name);
extern int owl_global_get_style_names(owl_global *g, owl_list *l);
extern void owl_global_add_style(owl_global *g, owl_style *s);
extern char *owl_global_get_response(owl_global *g);
extern void owl_global_set_response(owl_global *g, char *resp);
extern void owl_global_set_haveaim(owl_global *g);
extern int owl_global_is_haveaim(owl_global *g);
extern void owl_global_set_havezephyr(owl_global *g);
extern int owl_global_is_havezephyr(owl_global *g);
extern owl_timer *owl_global_get_aim_buddyinfo_timer(owl_global *g);

/* -------------------------------- help.c -------------------------------- */
extern void owl_help();

/* -------------------------------- history.c -------------------------------- */
extern void owl_history_init(owl_history *h);
extern char *owl_history_get_prev(owl_history *h);
extern char *owl_history_get_next(owl_history *h);
extern void owl_history_store(owl_history *h, char *line);
extern void owl_history_set_partial(owl_history *h);
extern void owl_history_reset(owl_history *h);
extern int owl_history_is_touched(owl_history *h);

/* -------------------------------- keybinding.c -------------------------------- */
extern int owl_keybinding_init(owl_keybinding *kb, char *keyseq, char *command, void (*function_fn)(void), char *desc);
extern void owl_keybinding_free(owl_keybinding *kb);
extern void owl_keybinding_free_all(owl_keybinding *kb);
extern void owl_keybinding_execute(owl_keybinding *kb, int j);
extern int owl_keybinding_stack_tostring(int *j, char *buff, int bufflen);
extern int owl_keybinding_tostring(owl_keybinding *kb, char *buff, int bufflen);
extern char *owl_keybinding_get_desc(owl_keybinding *kb);
extern int owl_keybinding_match(owl_keybinding *kb, int *kpstack);
extern int owl_keybinding_equal(owl_keybinding *kb1, owl_keybinding *kb2);

/* -------------------------------- keymap.c -------------------------------- */
extern int owl_keymap_init(owl_keymap *km, char *name, char *desc, void (*default_fn)(int), void (*prealways_fn)(int), void (*postalways_fn)(int));
extern void owl_keymap_free(owl_keymap *km);
extern void owl_keymap_set_submap(owl_keymap *km, owl_keymap *submap);
extern int owl_keymap_create_binding(owl_keymap *km, char *keyseq, char *command, void (*function_fn)(void), char *desc);
extern char *owl_keymap_summary(owl_keymap *km);
extern void owl_keymap_get_details(owl_keymap *km, owl_fmtext *fm);
extern int owl_keyhandler_init(owl_keyhandler *kh);
extern void owl_keyhandler_add_keymap(owl_keyhandler *kh, owl_keymap *km);
extern owl_keymap *owl_keyhandler_create_and_add_keymap(owl_keyhandler *kh, char *name, char *desc, void (*default_fn)(int), void (*prealways_fn)(int), void (*postalways_fn)(int));
extern void owl_keyhandler_reset(owl_keyhandler *kh);
extern owl_keymap *owl_keyhandler_get_keymap(owl_keyhandler *kh, char *mapname);
extern void owl_keyhandler_get_keymap_names(owl_keyhandler *kh, owl_list *l);
extern void owl_keyhandler_keymap_namelist_free(owl_list *l);
extern owl_keymap *owl_keyhandler_activate(owl_keyhandler *kh, char *mapname);
extern int owl_keyhandler_process(owl_keyhandler *kh, int j);
extern void owl_keyhandler_invalidkey(owl_keyhandler *kh);

/* -------------------------------- keypress.c -------------------------------- */
#ifdef KEY_CODE_YES
#endif
#ifdef KEY_RESIZE
#endif
extern int owl_keypress_tostring(int j, int esc, char *buff, int bufflen);
extern int owl_keypress_fromstring(char *kb);

/* -------------------------------- keys.c -------------------------------- */
extern void owl_keys_setup_keymaps(owl_keyhandler *kh);
extern void owl_keys_recwin_prealways(int j);
extern void owl_keys_editwin_default(int j);
extern void owl_keys_editwin_postalways(int j);
extern void owl_keys_popless_postalways(int j);
extern void owl_keys_default_invalid(int j);

/* -------------------------------- list.c -------------------------------- */
extern int owl_list_create(owl_list *l);
extern int owl_list_get_size(owl_list *l);
extern void *owl_list_get_element(owl_list *l, int n);
extern int owl_list_append_element(owl_list *l, void *element);
extern int owl_list_prepend_element(owl_list *l, void *element);
extern int owl_list_remove_element(owl_list *l, int n);
extern int owl_list_replace_element(owl_list *l, int n, void *element);
extern void owl_list_free_all(owl_list *l, void (*elefree)(void *));
extern void owl_list_free_simple(owl_list *l);

/* -------------------------------- logging.c -------------------------------- */
extern void owl_log_outgoing_zephyr(char *to, char *text);
extern void owl_log_outgoing_aim(char *to, char *text);
extern void owl_log_incoming(owl_message *m);

/* -------------------------------- mainwin.c -------------------------------- */
extern void owl_mainwin_init(owl_mainwin *mw);
extern void owl_mainwin_redisplay(owl_mainwin *mw);
extern int owl_mainwin_is_curmsg_truncated(owl_mainwin *mw);
extern int owl_mainwin_is_last_msg_truncated(owl_mainwin *mw);
extern int owl_mainwin_get_last_msg(owl_mainwin *mw);

/* -------------------------------- message.c -------------------------------- */
extern void owl_message_init(owl_message *m);
extern void owl_message_set_attribute(owl_message *m, char *attrname, char *attrvalue);
extern char *owl_message_get_attribute_value(owl_message *m, char *attrname);
extern void owl_message_attributes_tofmtext(owl_message *m, owl_fmtext *fm);
extern void owl_message_invalidate_format(owl_message *m);
extern owl_fmtext *owl_message_get_fmtext(owl_message *m);
extern void owl_message_format(owl_message *m);
extern void owl_message_set_class(owl_message *m, char *class);
extern char *owl_message_get_class(owl_message *m);
extern void owl_message_set_instance(owl_message *m, char *inst);
extern char *owl_message_get_instance(owl_message *m);
extern void owl_message_set_sender(owl_message *m, char *sender);
extern char *owl_message_get_sender(owl_message *m);
extern void owl_message_set_zsig(owl_message *m, char *zsig);
extern char *owl_message_get_zsig(owl_message *m);
extern void owl_message_set_recipient(owl_message *m, char *recip);
extern char *owl_message_get_recipient(owl_message *m);
extern void owl_message_set_realm(owl_message *m, char *realm);
extern char *owl_message_get_realm(owl_message *m);
extern void owl_message_set_body(owl_message *m, char *body);
extern char *owl_message_get_body(owl_message *m);
extern void owl_message_set_opcode(owl_message *m, char *opcode);
extern char *owl_message_get_opcode(owl_message *m);
extern void owl_message_set_islogin(owl_message *m);
extern void owl_message_set_islogout(owl_message *m);
extern int owl_message_is_loginout(owl_message *m);
extern int owl_message_is_login(owl_message *m);
extern int owl_message_is_logout(owl_message *m);
extern void owl_message_set_isprivate(owl_message *m);
extern int owl_message_is_private(owl_message *m);
extern char *owl_message_get_timestr(owl_message *m);
extern void owl_message_set_type_admin(owl_message *m);
extern void owl_message_set_type_zephyr(owl_message *m);
extern void owl_message_set_type_aim(owl_message *m);
extern int owl_message_is_type_admin(owl_message *m);
extern int owl_message_is_type_zephyr(owl_message *m);
extern int owl_message_is_type_aim(owl_message *m);
extern int owl_message_is_type_generic(owl_message *m);
extern char *owl_message_type_to_string(owl_message *m);
extern char *owl_message_get_text(owl_message *m);
extern void owl_message_set_direction_in(owl_message *m);
extern void owl_message_set_direction_out(owl_message *m);
extern void owl_message_set_direction_none(owl_message *m);
extern int owl_message_is_direction_in(owl_message *m);
extern int owl_message_is_direction_out(owl_message *m);
extern int owl_message_is_direction_none(owl_message *m);
extern int owl_message_get_numlines(owl_message *m);
extern void owl_message_mark_delete(owl_message *m);
extern void owl_message_unmark_delete(owl_message *m);
extern char *owl_message_get_zwriteline(owl_message *m);
extern void owl_message_set_zwriteline(owl_message *m, char *line);
extern int owl_message_is_delete(owl_message *m);
#ifdef HAVE_LIBZEPHYR
extern ZNotice_t *owl_message_get_notice(owl_message *m);
#else
extern void *owl_message_get_notice(owl_message *m);
#endif
extern char *owl_message_get_hostname(owl_message *m);
extern void owl_message_curs_waddstr(owl_message *m, WINDOW *win, int aline, int bline, int acol, int bcol, int color);
extern int owl_message_is_personal(owl_message *m);
extern int owl_message_is_from_me(owl_message *m);
extern int owl_message_is_mail(owl_message *m);
extern int owl_message_is_ping(owl_message *m);
extern int owl_message_is_burningears(owl_message *m);
extern char *owl_message_get_cc(owl_message *m);
extern int owl_message_get_id(owl_message *m);
extern char *owl_message_get_type(owl_message *m);
extern char *owl_message_get_direction(owl_message *m);
extern char *owl_message_get_login(owl_message *m);
extern char *owl_message_get_header(owl_message *m);
extern int owl_message_search(owl_message *m, char *string);
extern void owl_message_create_aim(owl_message *m, char *sender, char *recipient, char *text, int direction, int loginout);
extern void owl_message_create_admin(owl_message *m, char *header, char *text);
#ifdef HAVE_LIBZEPHYR
extern void owl_message_create_from_znotice(owl_message *m, ZNotice_t *n);
#ifdef OWL_ENABLE_ZCRYPT
#endif  
#else
extern void owl_message_create_from_znotice(owl_message *m, void *n);
#endif
extern void owl_message_create_from_zwriteline(owl_message *m, char *line, char *body, char *zsig);
extern void owl_message_pretty_zsig(owl_message *m, char *buff);
extern void owl_message_free(owl_message *m);
#ifdef HAVE_LIBZEPHYR    
#endif

/* -------------------------------- messagelist.c -------------------------------- */
extern int owl_messagelist_create(owl_messagelist *ml);
extern int owl_messagelist_get_size(owl_messagelist *ml);
extern void *owl_messagelist_get_element(owl_messagelist *ml, int n);
extern owl_message *owl_messagelist_get_by_id(owl_messagelist *ml, int id);
extern int owl_messagelist_append_element(owl_messagelist *ml, void *element);
extern int owl_messagelist_delete_element(owl_messagelist *ml, int n);
extern int owl_messagelist_undelete_element(owl_messagelist *ml, int n);
extern int owl_messagelist_expunge(owl_messagelist *ml);
extern void owl_messagelist_invalidate_formats(owl_messagelist *ml);

/* -------------------------------- owl.c -------------------------------- */
extern int main(int argc, char **argv, char **env);
#ifdef HAVE_LIBZEPHYR
#endif
#ifdef HAVE_LIBZEPHYR
#endif
#ifdef HAVE_USE_DEFAULT_COLORS
#endif
#ifdef HAVE_LIBZEPHYR
#endif
#ifdef HAVE_LIBZEPHYR
#endif
#ifdef HAVE_LIBZEPHYR
#endif
extern void sig_handler(int sig);
extern void usage();

/* -------------------------------- pair.c -------------------------------- */
extern void owl_pair_create(owl_pair *p, void *key, void *value);
extern void owl_pair_set_key(owl_pair *p, void *key);
extern void owl_pair_set_value(owl_pair *p, void *value);
extern void *owl_pair_get_key(owl_pair *p);
extern void *owl_pair_get_value(owl_pair *p);

/* -------------------------------- perlconfig.c -------------------------------- */
extern char *owl_perlconfig_call_with_message(char *subname, owl_message *m);
extern char *owl_perlconfig_readconfig(char *file);
extern int owl_perlconfig_is_function(char *fn);
extern int owl_perlconfig_get_hashkeys(char *hashname, owl_list *l);
extern char *owl_perlconfig_execute(char *line);
extern char *owl_perlconfig_getmsg(owl_message *m, int mode, char *subname); 

/* -------------------------------- perlglue.c -------------------------------- */
#ifdef HAVE_LIBZEPHYR
#endif
#ifdef __cplusplus
#endif

/* -------------------------------- perlwrap.c -------------------------------- */

/* -------------------------------- popwin.c -------------------------------- */
extern int owl_popwin_init(owl_popwin *pw);
extern int owl_popwin_up(owl_popwin *pw);
extern int owl_popwin_display_text(owl_popwin *pw, char *text);
extern int owl_popwin_close(owl_popwin *pw);
extern int owl_popwin_is_active(owl_popwin *pw);
extern int owl_popwin_refresh(owl_popwin *pw);
extern void owl_popwin_set_handler(owl_popwin *pw, void (*func)(int ch));
extern void owl_popwin_unset_handler(owl_popwin *pw);
extern WINDOW *owl_popwin_get_curswin(owl_popwin *pw);
extern int owl_popwin_get_lines(owl_popwin *pw);
extern int owl_popwin_get_cols(owl_popwin *pw);
extern int owl_popwin_needs_first_refresh(owl_popwin *pw);
extern void owl_popwin_no_needs_first_refresh(owl_popwin *pw);

/* -------------------------------- regex.c -------------------------------- */
extern void owl_regex_init(owl_regex *re);
extern int owl_regex_create(owl_regex *re, char *string);
extern int owl_regex_compare(owl_regex *re, char *string);
extern int owl_regex_is_set(owl_regex *re);
extern char *owl_regex_get_string(owl_regex *re);
extern void owl_regex_copy(owl_regex *a, owl_regex *b);
extern void owl_regex_free(owl_regex *re);

/* -------------------------------- style.c -------------------------------- */
extern void owl_style_create_internal(owl_style *s, char *name, void (*formatfunc) (owl_fmtext *fm, owl_message *m), char *description);
extern void owl_style_create_perl(owl_style *s, char *name, char *perlfuncname, char *description);
extern int owl_style_matches_name(owl_style *s, char *name);
extern char *owl_style_get_name(owl_style *s);
extern char *owl_style_get_description(owl_style *s);
extern void owl_style_get_formattext(owl_style *s, owl_fmtext *fm, owl_message *m);
extern int owl_style_validate(owl_style *s);
extern void owl_style_free(owl_style *s);

/* -------------------------------- stylefunc.c -------------------------------- */
extern void owl_stylefunc_basic(owl_fmtext *fm, owl_message *m);
#ifdef HAVE_LIBZEPHYR
#endif
#ifdef HAVE_LIBZEPHYR
#endif
extern void owl_stylefunc_default(owl_fmtext *fm, owl_message *m);
#ifdef HAVE_LIBZEPHYR
#endif
#ifdef HAVE_LIBZEPHYR
#endif
extern void owl_stylefunc_oneline(owl_fmtext *fm, owl_message *m);
#ifdef HAVE_LIBZEPHYR
#endif
#ifdef HAVE_LIBZEPHYR
#endif

/* -------------------------------- tester.c -------------------------------- */
extern void screeninit();
extern void test1();
extern void test2(char *in);
extern void test3();
extern void colorinfo();
extern void test4();
extern void test_keypress();
extern int main(int argc, char **argv, char **env);

/* -------------------------------- text.c -------------------------------- */
extern int owl_text_truncate_lines(char *out, char *in, int aline, int lines);
extern void owl_text_truncate_cols(char *out, char *in, int acol, int bcol);
extern void owl_text_indent(char *out, char *in, int n);
extern int owl_text_num_lines(char *in);
extern char *owl_text_htmlstrip(char *in);
extern char *owl_text_wordwrap(char *in, int col);

/* -------------------------------- timer.c -------------------------------- */
extern void owl_timer_create_countup(owl_timer *t);
extern void owl_timer_create_countdown(owl_timer *t, int start);
extern void owl_timer_reset(owl_timer *t);
extern void owl_timer_reset_newstart(owl_timer *t, int start);
extern int owl_timer_get_time(owl_timer *t);
extern int owl_timer_is_expired(owl_timer *t);

/* -------------------------------- util.c -------------------------------- */
extern void sepbar(char *in);
extern void pophandler_quit(int ch);
extern char **atokenize(char *buffer, char *sep, int *i);
extern char *skiptokens(char *buff, int n);
extern void atokenize_free(char **tok, int nels);
extern void owl_parsefree(char **argv, int argc);
extern char **owl_parseline(char *line, int *argc);
extern char *owl_util_minutes_to_timestr(int in);
extern int owl_util_find_trans(char *in, int len);
extern void downstr(char *foo);
extern char *stristr(char *a, char *b);
extern char *owl_util_uniq(char *A, char *B, char *prohibit);
extern int only_whitespace(char *s);
extern void *owl_malloc(size_t size);
extern void owl_free(void *ptr);
extern char *owl_strdup(const char *s1);
extern void *owl_realloc(void *ptr, size_t size);
extern char *owl_sprintf(const char *fmt, ...);
extern char *short_zuser(char *in);
extern char *long_zuser(char *in);
extern char *owl_util_smartstripped_user(char *in);
extern char *owl_getquoting(char *line);
extern char *owl_util_substitute(char *in, char *from, char *to);
extern void owl_util_tr(char *buff, char a, char b);
extern int owl_util_string_to_color(char *color);
extern char *owl_util_color_to_string(int color);
extern char *owl_util_get_default_tty();
extern void owl_hack_animate();
extern char *owl_util_stripnewlines(char *in);
extern void owl_util_file_deleteline(char *filename, char *line, int backup);
#ifdef OWL_INCLUDE_REG_TESTS
extern int owl_util_regtest(void);
#endif /* OWL_INCLUDE_REG_TESTS */

/* -------------------------------- variable.c -------------------------------- */
extern int owl_variable_int_validate_gt0(owl_variable *v, void *newval);
extern int owl_variable_int_validate_positive(owl_variable *v, void *newval);
extern int owl_variable_typewinsize_set(owl_variable *v, void *newval);
extern int owl_variable_debug_set(owl_variable *v, void *newval);
extern int owl_variable_disable_ctrl_d_set(owl_variable *v, void *newval);
extern int owl_variable_tty_set(owl_variable *v, void *newval);
extern int owl_variable_dict_setup(owl_vardict *vd);
extern void owl_variable_dict_free(owl_vardict *d);
extern void owl_variable_dict_get_names(owl_vardict *d, owl_list *l);
extern void owl_variable_dict_namelist_free(owl_list *l);
extern void owl_variable_free(owl_variable *v);
extern char *owl_variable_get_description(owl_variable *v);
extern char *owl_variable_get_summary(owl_variable *v);
extern char *owl_variable_get_validsettings(owl_variable *v);
extern int owl_variable_set_fromstring(owl_vardict *d, char *name, char *value, int msg, int requirebool);
extern int owl_variable_set_string(owl_vardict *d, char *name, char *newval);
extern int owl_variable_set_int(owl_vardict *d, char *name, int newval);
extern int owl_variable_set_bool_on(owl_vardict *d, char *name);
extern int owl_variable_set_bool_off(owl_vardict *d, char *name);
extern int owl_variable_get_tostring(owl_vardict *d, char *name, char *buf, int bufsize);
extern int owl_variable_get_default_tostring(owl_vardict *d, char *name, char *buf, int bufsize);
extern void *owl_variable_get(owl_vardict *d, char *name, int require_type);
extern char *owl_variable_get_string(owl_vardict *d, char *name);
extern void *owl_variable_get_other(owl_vardict *d, char *name);
extern int owl_variable_get_int(owl_vardict *d, char *name);
extern int owl_variable_get_bool(owl_vardict *d, char *name);
extern void owl_variable_describe(owl_vardict *d, char *name, owl_fmtext *fm);
extern void owl_variable_get_help(owl_vardict *d, char *name, owl_fmtext *fm);
extern void *owl_variable_get_default(owl_variable *v);
extern void owl_variable_free_default(owl_variable *v);
extern int owl_variable_bool_validate_default(owl_variable *v, void *newval);
extern int owl_variable_bool_set_default(owl_variable *v, void *newval);
extern int owl_variable_bool_set_fromstring_default(owl_variable *v, char *newval);
extern int owl_variable_bool_get_tostring_default(owl_variable *v, char* buf, int bufsize, void *val);
extern int owl_variable_int_validate_default(owl_variable *v, void *newval);
extern int owl_variable_int_set_default(owl_variable *v, void *newval);
extern int owl_variable_int_set_fromstring_default(owl_variable *v, char *newval);
extern int owl_variable_int_get_tostring_default(owl_variable *v, char* buf, int bufsize, void *val);
extern int owl_variable_enum_validate(owl_variable *v, void *newval);  
extern int owl_variable_enum_set_fromstring(owl_variable *v, char *newval);
extern int owl_variable_enum_get_tostring(owl_variable *v, char* buf, int bufsize, void *val);
extern int owl_variable_string_validate_default(struct _owl_variable *v, void *newval);
extern int owl_variable_string_set_default(owl_variable *v, void *newval);
extern int owl_variable_string_set_fromstring_default(owl_variable *v, char *newval);
extern int owl_variable_string_get_tostring_default(owl_variable *v, char* buf, int bufsize, void *val);
#ifdef OWL_INCLUDE_REG_TESTS
extern int owl_variable_regtest(void);
#endif /* OWL_INCLUDE_REG_TESTS */

/* -------------------------------- varstubs.c -------------------------------- */
extern void owl_global_set_personalbell_on(owl_global *g);
extern void owl_global_set_personalbell_off(owl_global *g);
extern int owl_global_is_personalbell(owl_global *g);
extern void owl_global_set_bell_on(owl_global *g);
extern void owl_global_set_bell_off(owl_global *g);
extern int owl_global_is_bell(owl_global *g);
extern void owl_global_set_debug_on(owl_global *g);
extern void owl_global_set_debug_off(owl_global *g);
extern int owl_global_is_debug(owl_global *g);
extern void owl_global_set_startuplogin_on(owl_global *g);
extern void owl_global_set_startuplogin_off(owl_global *g);
extern int owl_global_is_startuplogin(owl_global *g);
extern void owl_global_set_shutdownlogout_on(owl_global *g);
extern void owl_global_set_shutdownlogout_off(owl_global *g);
extern int owl_global_is_shutdownlogout(owl_global *g);
extern void owl_global_set_rxping_on(owl_global *g);
extern void owl_global_set_rxping_off(owl_global *g);
extern int owl_global_is_rxping(owl_global *g);
extern void owl_global_set_txping_on(owl_global *g);
extern void owl_global_set_txping_off(owl_global *g);
extern int owl_global_is_txping(owl_global *g);
extern void owl_global_set_sepbar_disable_on(owl_global *g);
extern void owl_global_set_sepbar_disable_off(owl_global *g);
extern int owl_global_is_sepbar_disable(owl_global *g);
extern void owl_global_set_smartstrip_on(owl_global *g);
extern void owl_global_set_smartstrip_off(owl_global *g);
extern int owl_global_is_smartstrip(owl_global *g);
extern void owl_global_set_newlinestrip_on(owl_global *g);
extern void owl_global_set_newlinestrip_off(owl_global *g);
extern int owl_global_is_newlinestrip(owl_global *g);
extern void owl_global_set_displayoutgoing_on(owl_global *g);
extern void owl_global_set_displayoutgoing_off(owl_global *g);
extern int owl_global_is_displayoutgoing(owl_global *g);
extern void owl_global_set_loginsubs_on(owl_global *g);
extern void owl_global_set_loginsubs_off(owl_global *g);
extern int owl_global_is_loginsubs(owl_global *g);
extern void owl_global_set_logging_on(owl_global *g);
extern void owl_global_set_logging_off(owl_global *g);
extern int owl_global_is_logging(owl_global *g);
extern void owl_global_set_classlogging_on(owl_global *g);
extern void owl_global_set_classlogging_off(owl_global *g);
extern int owl_global_is_classlogging(owl_global *g);
extern void owl_global_set_colorztext_on(owl_global *g);
extern void owl_global_set_colorztext_off(owl_global *g);
extern int owl_global_is_colorztext(owl_global *g);
extern void owl_global_set_zcrypt_on(owl_global *g);
extern void owl_global_set_zcrypt_off(owl_global *g);
extern int owl_global_is_zcrypt(owl_global *g);
extern void owl_global_set_lockout_ctrld(owl_global *g, int n);
extern int owl_global_get_lockout_ctrld(owl_global *g);
extern void owl_global_set_burningears_on(owl_global *g);
extern void owl_global_set_burningears_off(owl_global *g);
extern int owl_global_is_burningears(owl_global *g);
extern void owl_global_set_summarymode_on(owl_global *g);
extern void owl_global_set_summarymode_off(owl_global *g);
extern int owl_global_is_summarymode(owl_global *g);
extern void owl_global_set_logpath(owl_global *g, char *text);
extern char *owl_global_get_logpath(owl_global *g);
extern void owl_global_set_classlogpath(owl_global *g, char *text);
extern char *owl_global_get_classlogpath(owl_global *g);
extern void owl_global_set_debug_file(owl_global *g, char *text);
extern char *owl_global_get_debug_file(owl_global *g);
extern void owl_global_set_zsigproc(owl_global *g, char *text);
extern char *owl_global_get_zsigproc(owl_global *g);
extern void owl_global_set_newmsgproc(owl_global *g, char *text);
extern char *owl_global_get_newmsgproc(owl_global *g);
extern void owl_global_set_zsig(owl_global *g, char *text);
extern char *owl_global_get_zsig(owl_global *g);
extern void owl_global_set_appendtosepbar(owl_global *g, char *text);
extern char *owl_global_get_appendtosepbar(owl_global *g);
extern void owl_global_set_zaway_on(owl_global *g);
extern void owl_global_set_zaway_off(owl_global *g);
extern int owl_global_is_zaway(owl_global *g);
extern void owl_global_set_zaway_msg(owl_global *g, char *text);
extern char *owl_global_get_zaway_msg(owl_global *g);
extern void owl_global_set_zaway_msg_default(owl_global *g, char *text);
extern char *owl_global_get_zaway_msg_default(owl_global *g);
extern void owl_global_set_view_home(owl_global *g, char *text);
extern char *owl_global_get_view_home(owl_global *g);
extern void owl_global_set_alert_filter(owl_global *g, char *text);
extern char *owl_global_get_alert_filter(owl_global *g);
extern void owl_global_set_alert_action(owl_global *g, char *text);
extern char *owl_global_get_alert_action(owl_global *g);
extern void owl_global_set_tty(owl_global *g, char *text);
extern char *owl_global_get_tty(owl_global *g);
extern void owl_global_set_default_style(owl_global *g, char *text);
extern char *owl_global_get_default_style(owl_global *g);
extern void owl_global_set_edit_maxfillcols(owl_global *g, int n);
extern int owl_global_get_edit_maxfillcols(owl_global *g);
extern void owl_global_set_edit_maxwrapcols(owl_global *g, int n);
extern int owl_global_get_edit_maxwrapcols(owl_global *g);
extern void owl_global_set_aim_ignorelogin_timer(owl_global *g, int n);
extern int owl_global_get_aim_ignorelogin_timer(owl_global *g);
extern void owl_global_set_typwin_lines(owl_global *g, int n);
extern int owl_global_get_typwin_lines(owl_global *g);
extern void owl_global_set_scrollmode(owl_global *g, int n);
extern int owl_global_get_scrollmode(owl_global *g);
extern void owl_global_set_webbrowser(owl_global *g, int n);
extern int owl_global_get_webbrowser(owl_global *g);
extern void owl_global_set__followlast_on(owl_global *g);
extern void owl_global_set__followlast_off(owl_global *g);
extern int owl_global_is__followlast(owl_global *g);

/* -------------------------------- view.c -------------------------------- */
extern void owl_view_create(owl_view *v, char *name, owl_filter *f, owl_style *s);
extern char *owl_view_get_name(owl_view *v);
extern void owl_view_consider_message(owl_view *v, owl_message *m);
extern void owl_view_recalculate(owl_view *v);
extern void owl_view_new_filter(owl_view *v, owl_filter *f);
extern void owl_view_set_style(owl_view *v, owl_style *s);
extern owl_style *owl_view_get_style(owl_view *v);
extern char *owl_view_get_style_name(owl_view *v);
extern owl_message *owl_view_get_element(owl_view *v, int index);
extern void owl_view_delete_element(owl_view *v, int index);
extern void owl_view_undelete_element(owl_view *v, int index);
extern int owl_view_get_size(owl_view *v);
extern int owl_view_get_nearest_to_msgid(owl_view *v, int targetid);
extern int owl_view_get_nearest_to_saved(owl_view *v);
extern void owl_view_save_curmsgid(owl_view *v, int curid);
extern void owl_view_to_fmtext(owl_view *v, owl_fmtext *fm);
extern char *owl_view_get_filtname(owl_view *v);
extern void owl_view_free(owl_view *v);

/* -------------------------------- viewwin.c -------------------------------- */
extern void owl_viewwin_init_text(owl_viewwin *v, WINDOW *win, int winlines, int wincols, char *text);
extern void owl_viewwin_init_fmtext(owl_viewwin *v, WINDOW *win, int winlines, int wincols, owl_fmtext *fmtext);
extern void owl_viewwin_set_curswin(owl_viewwin *v, WINDOW *w, int winlines, int wincols);
extern void owl_viewwin_redisplay(owl_viewwin *v, int update);
extern void owl_viewwin_pagedown(owl_viewwin *v);
extern void owl_viewwin_linedown(owl_viewwin *v);
extern void owl_viewwin_pageup(owl_viewwin *v);
extern void owl_viewwin_lineup(owl_viewwin *v);
extern void owl_viewwin_right(owl_viewwin *v, int n);
extern void owl_viewwin_left(owl_viewwin *v, int n);
extern void owl_viewwin_top(owl_viewwin *v);
extern void owl_viewwin_bottom(owl_viewwin *v);
extern void owl_viewwin_free(owl_viewwin *v);

/* -------------------------------- zcrypt.c -------------------------------- */
#ifdef OWL_ENABLE_ZCRYPT
#ifndef TRUE
#endif
#ifndef FALSE
#endif
#ifndef HAVE_DES_ECB_ENCRYPT_PROTO
#endif
extern int zcrypt(int argc, char *argv[]);
extern int owl_zcrypt_decrypt(char *out, char *in, char *class, char *instance);
extern int owl_zcrypt_encrypt(char *out, char *in, char *class, char *instance);
extern char *BuildArgString(char **argv, int start, int end);
extern char *GetZephyrVarKeyFile(char *whoami, char *class, char *instance);
extern void CloseZephyrPipe(FILE *pipe);
extern void block_to_ascii(char *output, FILE *outfile);
extern int read_ascii_nybble();
extern int read_ascii_byte();
extern int read_ascii_block(char *input);
extern int do_decrypt(char *keystring);
#endif

/* -------------------------------- zephyr.c -------------------------------- */
#ifdef HAVE_LIBZEPHYR
#endif
extern int owl_zephyr_initialize();
#ifdef HAVE_LIBZEPHYR
#endif
extern int owl_zephyr_shutdown();
#ifdef HAVE_LIBZEPHYR
#endif
extern int owl_zephyr_zpending();
#ifdef HAVE_LIBZEPHYR
#else
#endif
extern char *owl_zephyr_get_realm();
#ifdef HAVE_LIBZEPHYR
#else
#endif
extern char *owl_zephyr_get_sender();
#ifdef HAVE_LIBZEPHYR
#else
#endif
extern int owl_zephyr_loadsubs(char *filename);
#ifdef HAVE_LIBZEPHYR
#else
#endif
extern int owl_zephyr_loadloginsubs(char *filename);
#ifdef HAVE_LIBZEPHYR
#else
#endif
extern void unsuball();
#if HAVE_LIBZEPHYR
#endif
extern int owl_zephyr_sub(char *class, char *inst, char *recip);
#ifdef HAVE_LIBZEPHYR
#else
#endif
extern int owl_zephyr_unsub(char *class, char *inst, char *recip);
#ifdef HAVE_LIBZEPHYR
#else
#endif
#ifdef HAVE_LIBZEPHYR
extern char *owl_zephyr_get_field(ZNotice_t *n, int j, int *k);
#else
extern char *owl_zephyr_get_field(void *n, int j, int *k);
#endif
#ifdef HAVE_LIBZEPHYR
extern int owl_zephyr_get_num_fields(ZNotice_t *n);
#else
extern int owl_zephyr_get_num_fields(void *n);
#endif
#ifdef HAVE_LIBZEPHYR
extern char *owl_zephyr_get_message(ZNotice_t *n, int *k);
#endif
#ifdef HAVE_LIBZEPHYR
extern char *owl_zephyr_get_zsig(ZNotice_t *n, int *k);
#else
extern char *owl_zephyr_get_zsig(void *n, int *k);
#endif
extern int send_zephyr(char *opcode, char *zsig, char *class, char *instance, char *recipient, char *message);
#ifdef HAVE_LIBZEPHYR
#else
#endif
#ifdef HAVE_LIBZEPHYR
extern Code_t send_zephyr_helper(ZNotice_t *notice, char *buf, int len, int wait);
#endif
extern void send_ping(char *to);
#ifdef HAVE_LIBZEPHYR
#endif
#ifdef HAVE_LIBZEPHYR
extern void owl_zephyr_handle_ack(ZNotice_t *retnotice);
#else
extern void owl_zephyr_handle_ack(void *retnotice);
#endif
#ifdef HAVE_LIBZEPHYR
extern int owl_zephyr_notice_is_ack(ZNotice_t *n);
#else
extern int owl_zephyr_notice_is_ack(void *n);
#endif
extern void owl_zephyr_zaway(owl_message *m);
#ifdef HAVE_LIBZEPHYR
#endif
#ifdef HAVE_LIBZEPHYR
extern void owl_zephyr_hackaway_cr(ZNotice_t *n);
#endif
extern void owl_zephyr_zlocate(char *user, char *out, int auth);
#ifdef HAVE_LIBZEPHYR
#endif
extern void owl_zephyr_addsub(char *filename, char *class, char *inst, char *recip);
#ifdef HAVE_LIBZEPHYR
#endif
extern void owl_zephyr_delsub(char *filename, char *class, char *inst, char *recip);
#ifdef HAVE_LIBZEPHYR
#endif
extern char *owl_zephyr_makesubline(char *class, char *inst, char *recip);
extern void owl_zephyr_zlog_in(void);
#ifdef HAVE_LIBZEPHYR
#endif
extern void owl_zephyr_zlog_out(void);
#ifdef HAVE_LIBZEPHYR
#endif
extern void owl_zephyr_addbuddy(char *name);
extern void owl_zephyr_delbuddy(char *name);
#ifdef HAVE_LIBZEPHYR
extern char *owl_zephyr_get_authstr(ZNotice_t *n);
#else
extern char *owl_zephyr_get_authstr(void *n);
#endif
extern char *owl_zephyr_getsubs();
#ifdef HAVE_LIBZEPHYR
#else
#endif
extern char *owl_zephyr_get_variable(char *var);
#ifdef HAVE_LIBZEPHYR
#else
#endif
extern void owl_zephyr_set_locationinfo(char *host, char *val);
#ifdef HAVE_LIBZEPHYR
#endif

/* -------------------------------- zwrite.c -------------------------------- */
extern int owl_zwrite_create_from_line(owl_zwrite *z, char *line);
extern void owl_zwrite_send_ping(owl_zwrite *z);
extern void owl_zwrite_set_message(owl_zwrite *z, char *msg);
extern char *owl_zwrite_get_message(owl_zwrite *z);
extern int owl_zwrite_is_message_set(owl_zwrite *z);
extern int owl_zwrite_send_message(owl_zwrite *z);
extern int owl_zwrite_create_and_send_from_line(char *cmd, char *msg);
extern char *owl_zwrite_get_class(owl_zwrite *z);
extern char *owl_zwrite_get_instance(owl_zwrite *z);
extern char *owl_zwrite_get_opcode(owl_zwrite *z);
extern void owl_zwrite_set_opcode(owl_zwrite *z, char *opcode);
extern char *owl_zwrite_get_realm(owl_zwrite *z);
extern char *owl_zwrite_get_zsig(owl_zwrite *z);
extern void owl_zwrite_get_recipstr(owl_zwrite *z, char *buff);
extern int owl_zwrite_get_numrecips(owl_zwrite *z);
extern char *owl_zwrite_get_recip_n(owl_zwrite *z, int n);
extern int owl_zwrite_is_personal(owl_zwrite *z);
extern void owl_zwrite_free(owl_zwrite *z);

