#include <unistd.h>
#include <stdlib.h>
#include <regex.h>
#include <string.h>
#include "zlogger.h"

void zlogger_entry_init(zlogger_entry *e, char *name)
{
  /* I don't like this */
  memset(e, 0, sizeof(zlogger_entry));

  e->name=strdup(name);
  e->class=NULL;
  /* e->instance */
  /* e->opcode */
  e->negateinstance=0;
  e->negateopcode=0;
  e->logfile=NULL;
  e->logfilenoparse=0;
  e->nolog=0;
  e->logroll=0;
  e->loglife=0;
}

char *zlogger_entry_get_name(zlogger_entry *e)
{
  return(e->name);
}

int zlogger_entry_set_class(zlogger_entry *e, char *class)
{
  if (e->class) free(e->class);
  e->class=strdup(class);
  return(0);
}

char *zlogger_entry_get_class(zlogger_entry *e)
{
  if (e->class) return(e->class);
  return("");
}

int zlogger_entry_set_instance(zlogger_entry *e, char *instance)
{
  int ret;
  
  if (instance[0] != '!') {
    ret=regcomp(&(e->instance), instance, REGOPTS);
  } else {
    ret=regcomp(&(e->instance), instance+1, REGOPTS);
    e->negateinstance = 1;
  }
  return(ret);
}

void zlogger_entry_set_noparse(zlogger_entry *e)
{
  e->logfilenoparse=1;
}

int zlogger_entry_is_noparse(zlogger_entry *e)
{
  if (e->logfilenoparse) return(1);
  return(0);
}

int zlogger_entry_set_opcode(zlogger_entry *e, char *opcode)
{
  int ret;

  if (opcode[0] != '!') {
    ret=regcomp(&(e->opcode), opcode, REGOPTS);
  } else {
    ret=regcomp(&(e->opcode), opcode+1, REGOPTS);
    e->negateopcode = 1;
  }
  return(ret);
}

int zlogger_entry_is_match(zlogger_entry *e, char *class, char *inst, char *opcode)
{
  int foo;
  
  if (strcasecmp(e->class, class)) return(0);

  foo=regexec(&(e->instance), inst, 0, NULL, 0);
  if (!e->negateinstance && foo) return(0);
  if (e->negateinstance && !foo) return(0);

  foo=regexec(&(e->opcode), opcode, 0, NULL, 0);
  if (!e->negateopcode && foo) return(0);
  if (e->negateopcode && !foo) return(0);

  return(1);
}

void zlogger_entry_set_logfile(zlogger_entry *e, char *filename)
{
  if (e->logfile) free(e->logfile);
  e->logfile=strdup(filename);
}

char *zlogger_entry_get_logfile(zlogger_entry *e)
{
  if (e->logfile) return(e->logfile);
  return("");
}

void zlogger_entry_set_nolog_on(zlogger_entry *e)
{
  e->nolog=1;
}

void zlogger_entry_set_nolog_off(zlogger_entry *e)
{
  e->nolog=0;
}

int zlogger_entry_is_nolog(zlogger_entry *e)
{
  if (e->nolog) return(1);
  return(0);
}

void zlogger_entry_set_logroll_on(zlogger_entry *e)
{
  e->logroll=1;
}

void zlogger_entry_set_loglife_days(zlogger_entry *e, int days)
{
  e->loglife=days;
}

int zlogger_entry_is_logroll(zlogger_entry *e)
{
  if (e->logroll) return(1);
  return(0);
}

int zlogger_entry_get_loglife_days(zlogger_entry *e)
{
  return(e->loglife);
}
