#include "zlogger.h"
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

void zlogger_global_init(zlogger_global *g)
{
  char buff[1024];

  zlogger_list_create(&(g->entrylist));
  g->v5ticketfile=NULL;
  g->v4ticketfile=NULL;
  g->keytab=strdup("FILE:/etc/krb5.keytab");
  g->kservice=NULL;
  g->newtickets=6; /* in hours */
  g->newsubs=10;   /* in minutes */
  g->hostname[0]='\0';
  g->noafs=0;
  g->cells=NULL;
  g->aklog=strdup("/bin/athena/aklog");
  g->debug=0;
  
  /* default ticket file */
  sprintf(buff, "/tmp/tkt_zlogger_%i", (int) getpid());
  zlogger_global_set_ticketfile(g, buff);
}

void zlogger_global_set_debug(zlogger_global *g)
{
  g->debug=1;
}

int zlogger_global_is_debug(zlogger_global *g)
{
  if (g->debug) return(1);
  return(0);
}

void *zlogger_global_get_entrylist(zlogger_global *g)
{
  return(&(g->entrylist));
}

void zlogger_global_set_ticketfile(zlogger_global *g, char *ticketfile)
{
  int len;
  
  len=strlen(ticketfile)+20;

  if (g->v4ticketfile) free(g->v4ticketfile);
  g->v4ticketfile=malloc(len);
  sprintf(g->v4ticketfile, "%s.v4", ticketfile);

  if (g->v5ticketfile) free(g->v5ticketfile);
  g->v5ticketfile=malloc(len);
  sprintf(g->v5ticketfile, "%s.v5", ticketfile);
}

char *zlogger_global_get_v4_ticketfile(zlogger_global *g)
{
  return(g->v4ticketfile);
}

char *zlogger_global_get_v5_ticketfile(zlogger_global *g)
{
  return(g->v5ticketfile);
}

void zlogger_global_set_keytab(zlogger_global *g, char *keytab)
{
  if (g->keytab) free(g->keytab);
  g->keytab=strdup(keytab);
}

char *zlogger_global_get_keytab(zlogger_global *g)
{
  return(g->keytab);
}

void zlogger_global_set_kservice(zlogger_global *g, char *kservice)
{
  if (g->kservice) free(g->kservice);
  g->kservice=strdup(kservice);
}

char *zlogger_global_get_kservice(zlogger_global *g)
{
  return(g->kservice);
}

void zlogger_global_set_newtix_hours(zlogger_global *g, int hours)
{
  if (hours<0) hours=0;
  g->newtickets=hours;
}

int zlogger_global_get_newtix_hours(zlogger_global *g)
{
  return(g->newtickets);
}

void zlogger_global_set_newsubs_minutes(zlogger_global *g, int minutes)
{
  if (minutes<5) minutes=10;
  g->newsubs=minutes;
}

int zlogger_global_get_newsubs_minutes(zlogger_global *g)
{
  return(g->newsubs);
}

/* cells is a space separated list of AFS cells */
void zlogger_global_set_cells(zlogger_global *g, char *cells)
{
  if (g->cells) free(g->cells);
  g->cells=strdup(cells);
}

char *zlogger_global_get_cells(zlogger_global *g)
{
  if (g->cells==NULL) return("");
  return(g->cells);
}

void zlogger_global_set_aklog(zlogger_global *g, char *aklog)
{
  if (g->aklog) free(g->aklog);
  g->aklog=strdup(aklog);
}

char *zlogger_global_get_aklog(zlogger_global *g)
{
  return(g->aklog);
}

void zlogger_global_set_noafs(zlogger_global *g)
{
  g->noafs=1;
}

int zlogger_global_is_noafs(zlogger_global *g)
{
  if (g->noafs) return(1);
  return(0);
}
