#include "zlogger.h"
#include <stdlib.h>

#define INITSIZE 30
#define GROWAT 2
#define GROWBY 1.5

int zlogger_list_create(zlogger_list *l)
{
  l->size=0;
  l->list=(void **)malloc(INITSIZE*sizeof(void *));
  l->avail=INITSIZE;
  if (l->list==NULL) return(-1);
  return(0);
}

int zlogger_list_get_size(zlogger_list *l)
{
  return(l->size);
}

void *zlogger_list_get_element(zlogger_list *l, int n)
{
  if (n>l->size-1) return(NULL);
  return(l->list[n]);
}

int zlogger_list_append_element(zlogger_list *l, void *element)
{
  void *ptr;
  
  if ((l->size+1) > (l->avail/GROWAT)) {
    ptr=realloc(l->list, l->avail*GROWBY*sizeof(void *));
    if (ptr==NULL) return(-1);
    l->list=ptr;
    l->avail=l->avail*GROWBY;
  }

  l->list[l->size]=element;
  l->size++;
  return(0);
}

int zlogger_list_prepend_element(zlogger_list *l, void *element)
{
  void *ptr;
  int i;
 
  if ((l->size+1) > (l->avail/GROWAT)) {
    ptr=realloc(l->list, l->avail*GROWBY*sizeof(void *));
    if (ptr==NULL) return(-1);
    l->list=ptr;
    l->avail=l->avail*GROWBY;
  }

  for (i=l->size; i>0; i--) {
    l->list[i]=l->list[i-1];
  }
  l->list[0]=element;
  l->size++;
  return(0);
}

int zlogger_list_remove_element(zlogger_list *l, int n)
{
  int i;

  if (n>l->size-1) return(-1);
  for (i=n; i<l->size-1; i++) {
    l->list[i]=l->list[i+1];
  }
  l->size--;
  return(0);
}

/* todo: might leak memory */
int zlogger_list_replace_element(zlogger_list *l, int n, void *element)
{
  if (n>l->size-1) return(-1);

  l->list[n]=element;
  return(0);
}

void zlogger_list_free_all(zlogger_list *l, void (*elefree)(void *))
{
  int i;

  for (i=0; i<l->size; i++) {
    (elefree)(l->list[i]);
  }
  free(l->list);
}

void zlogger_list_free_simple(zlogger_list *l)
{
  if (l->list) free(l->list);
}
