#include <stdio.h>
#include <unistd.h>
#include <syslog.h>
#include <krb5.h>
#include <krb.h>
#include <string.h>
#include <sys/stat.h>
#include <ctype.h>

int is_weird(char *instance)
{
  int i, len, ch;

  /* between 1 and 25 characters */
  len=strlen(instance);
  if (len<1 || len>25) return(1);

  /* no /'s */
  if (strchr(instance, '/')) return(1);

  /* must start with [a-zA-Z0-9] */
  ch=instance[0];
  if (!isalnum(ch)) return(1);

  /* no unprintable characters */
  for (i=0; i<len; i++) {
    if (instance[i]<'!' || instance[i]>'~') return(1);
  }

  /* just to be sure ... should be covered above though */
  if (!strcmp(instance, ".") || !strcasecmp(instance, "..")) return(1);

  if (!strcasecmp(instance, "weird")) return(1);
  if (!strcasecmp(instance, "old")) return(1);
  if (!strcasecmp(instance, "index.html")) return(1);
  if (!strcasecmp(instance, "index.shtml")) return(1);
  return(0);
}

void securefile(char *path)
{
  struct stat sbuff;
  int ret;
  
  ret=lstat(path, &sbuff);
  if (ret) {
    if (errno == ENOENT) {
      return;
    } else {
      syslog(LOG_ERR, "%m doing lstat");
      return;
    }
  }

  if ((sbuff.st_mode & S_IFMT) != S_IFREG) {
    char logbuff[1024];

    /* if it's a link tell us where to, otherwise let us know it's weird */
    if ((sbuff.st_mode & S_IFMT) == S_IFLNK) {
      char link[1024];
      ret=readlink(path, link, 1024);
      if (ret==-1) strcpy(link, "an unknown file");
      sprintf(logbuff, "Found %s is a symlink to %s", path, link);
    } else if ((sbuff.st_mode & S_IFMT) == S_IFDIR) {
      sprintf(logbuff, "Found %s is a directory", path);
    } else {
      sprintf(logbuff, "Found %s is not a regular file", path);
    }
    syslog(LOG_WARNING, logbuff);

    /* try to unlink it */
    ret=unlink(path);
    if (ret) {
      sprintf(logbuff, "I was not able to unlink %s:%s", path, strerror(errno));
    } else {
      sprintf(logbuff, "unlinked %s", path);
    }
    syslog(LOG_WARNING, logbuff);
    
  }
}

/* Return a string with any occurances of 'from' replaced with 'to'.
 * Caller must free the return.
 */
char *zlogger_util_replace(char *in, char *from, char *to)
{
  char *out;
  int   outlen, tolen, fromlen, inpos=0, outpos=0;

  if (!*from) return strdup(in);

  outlen = strlen(in)+1;
  tolen  = strlen(to);
  fromlen  = strlen(from);
  out = malloc(outlen);

  while (in[inpos]) {
    if (!strncmp(in+inpos, from, fromlen)) {
      outlen += tolen;
      out = realloc(out, outlen);
      strcpy(out+outpos, to);
      inpos += fromlen;
      outpos += tolen;
    } else {
      out[outpos] = in[inpos];
      inpos++; outpos++;
    }
  }
  out[outpos] = '\0';
  return(out);
}


/* for some reason this isn't defined */
extern krb5_error_code krb524_convert_creds_kdc(krb5_context, krb5_creds *, CREDENTIALS *);

int k54srvutil(char *service, char *keytabfile, int interactive)
{
  krb5_error_code code;
  krb5_principal me;
  krb5_context context;
  krb5_creds my_creds;
  krb5_ccache cc;
  krb5_keytab keytab;
  krb5_get_init_creds_opt options;
  krb5_deltat starttime;
  char k4_aname[ANAME_SZ + 1];
  char k4_inst[INST_SZ + 1];
  char k4_realm[REALM_SZ + 1];
  char k4_name[ANAME_SZ + 1 + INST_SZ + 1 + REALM_SZ + 1];
  krb5_principal kpcserver = 0;
  krb5_creds increds;
  krb5_creds *v5creds = 0;
  CREDENTIALS v4creds;
  char buff[1024];
  
  memset(&starttime, 0, sizeof(starttime));

  krb5_init_context(&context);
  code=krb5_sname_to_principal(context, NULL, service, KRB5_NT_SRV_HST, &me);
  if (code!=0) {
    sprintf(buff, "Error getting kerberos principal name %s: %s", service?service:"default", error_message(code));
    if (interactive) {
      puts(buff);
    } else {
      syslog(LOG_ERR, "gethostname: %m");
    }
    return(code);
  }

  code=krb5_cc_default(context, &cc);
  if (code) {
    sprintf(buff, "Erring doing kerberos cc_default: %s", error_message(code));
    if (interactive) {
      puts(buff);
    } else {
      syslog(LOG_ERR, buff);
    }
    return(code);
  }

  code=krb5_kt_resolve(context, keytabfile, &keytab);
  if (code) {
    sprintf(buff, "Error resolving kerberos keytab: %s", error_message(code));
    if (interactive) {
      puts(buff);
    } else {
      syslog(LOG_ERR, buff);
    }
    return(code);
  }

  krb5_get_init_creds_opt_init(&options);
  memset(&my_creds, 0, sizeof(my_creds));
  code=krb5_get_init_creds_keytab(context, &my_creds, me, keytab, starttime, NULL, &options);
  if (code) {
    sprintf(buff, "Error getting kerberos tickets: %s", error_message(code));
    if (interactive) {
      puts(buff);
    } else {
      syslog(LOG_ERR, buff);
    }
    return(code);
  }

  code=krb5_cc_initialize(context, cc, me);
  if (code) {
    sprintf(buff, "Error initializing kerberos credentials cache: %s", error_message(code));
    if (interactive) {
      puts(buff);
    } else {
      syslog(LOG_ERR, buff);
    }
    return(code);
  }

  code=krb5_cc_store_cred(context, cc, &my_creds);
  if (code) {
    sprintf(buff, "Error storing kerberos credentials: %s", error_message(code));
    if (interactive) {
      puts(buff);
    } else {
      syslog(LOG_ERR, buff);
    }
    return(code);
  }

  code=krb5_524_conv_principal(context, me, k4_aname, k4_inst, k4_realm);
  /* do we have to bail on this error? */
  if (code) {
    k4_aname[0] = 0;
    k4_inst[0] = 0;
    k4_realm[0] = 0;
    sprintf(buff, "Error doing kerberos 5 to 4 converstion: %s\n", error_message(code));
    if (interactive) {
      puts(buff);
    } else {
      syslog(LOG_ERR, buff);
    }
    return(code);
  }

  if (k4_aname[0]=='\0') {
    sprintf(buff, "Error getting kerberos 4 principal in conversion.");
    if (interactive) {
      puts(buff);
    } else {
      syslog(LOG_ERR, buff);
    }
    return(code);
  }

  if (!k4_realm[0]) krb_get_lrealm(k4_realm, 1);
  if (k4_inst[0]) {
    sprintf(k4_name, "%s.%s@%s", k4_aname, k4_inst, k4_realm);
  } else {
    sprintf(k4_name, "%s@%s", k4_aname, k4_realm);
  }

  code=krb5_build_principal(context, &kpcserver,
			    krb5_princ_realm(context, me)->length,
			    krb5_princ_realm(context, me)->data, "krbtgt",
			    krb5_princ_realm(context, me)->data, NULL);
  if (code) {
    sprintf(buff, "Error while creating service principal name: %s", error_message(code));
    if (interactive) {
      puts(buff);
    } else {
      syslog(LOG_ERR, buff);
    }
    return(code);
  }

  memset((char *) &increds, 0, sizeof(increds));
  increds.client=me;
  increds.server=kpcserver;
  kpcserver=0;
  increds.times.endtime = 0;
  increds.keyblock.enctype = ENCTYPE_DES_CBC_CRC;
  code=krb5_get_credentials(context, 0, cc, &increds, &v5creds);
  if (code) {
    sprintf(buff, "Error getting v5 credentials: %s", error_message(code));
    if (interactive) {
      puts(buff);
    } else {
      syslog(LOG_ERR, buff);
    }
    return(code);
  }

  code=krb524_convert_creds_kdc(context, v5creds, &v4creds);
  if (code) {
    sprintf(buff, "Error converting to V4 credentials: %s", error_message(code));
    if (interactive) {
      puts(buff);
    } else {
      syslog(LOG_ERR, buff);
    }
    return(code);
  }

  /*  stolen from the v4 kinit */
  /* initialize ticket cache */
  code=in_tkt(v4creds.pname, v4creds.pinst);
  if (code!=KSUCCESS) {
    sprintf("Error trying to create kerberos V4 ticket file: %s", error_message(code));
    if (interactive) {
      puts(buff);
    } else {
      syslog(LOG_ERR, buff);
    }
    return(code);
  }
  
  /* stash ticket, session key, etc. for future use */
  code=krb_save_credentials(v4creds.service, v4creds.instance, v4creds.realm,
			    v4creds.session, v4creds.lifetime, v4creds.kvno,
			    &(v4creds.ticket_st), v4creds.issue_date);
  if (code!=KSUCCESS) {
    sprintf(buff, "Error trying to save the V4 ticket: %s", error_message(code));
    if (interactive) {
      puts(buff);
    } else {
      syslog(LOG_ERR, buff);
    }
    return(code);
  }

  memset(&v4creds, 0, sizeof(v4creds));
  if (v5creds) krb5_free_creds(context, v5creds);
  increds.client=0;
  krb5_free_cred_contents(context, &increds);
  if (kpcserver) krb5_free_principal(context, kpcserver);
  return(0);
}

char **atokenize(char *buffer, char *sep, int *i)
{
  char **args;
  char *workbuff, *foo;
  int done=0, first=1, count=0;

  workbuff=malloc(strlen(buffer)+1);
  memcpy(workbuff, buffer, strlen(buffer)+1);
  
  args=NULL;
  while (!done) {
    if (first) {
      first=0;
      foo=strtok(workbuff, sep);
    } else {
      foo=strtok(NULL, sep);
    }
    if (foo==NULL) {
      done=1;
    } else {
      args=(char **)realloc(args, sizeof(char *) * (count+1));
      args[count]=malloc(strlen(foo)+1);
      strcpy(args[count], foo);
      count++;
    }
  }
  *i=count;
  free(workbuff);
  return(args);
}

void downstr(char *foo)
{
  int i;
  for (i=0; foo[i]!=0; i++) {
    foo[i]=tolower(foo[i]);
  }
}
