#include "config.h"

#if defined(HAVE_LIBLWP) && defined(HAVE_LIBRX) && defined(HAVE_LIBSYS)
#  define ZLOGGER_HAVE_AFS
#endif

#ifdef HAVE_LIBZEPHYR
#  define ZLOGGER_HAVE_ZEPHYR
#endif

#define ZLOGGER_VERSION 1.3-pre-2
#define ZLOGGER_VERSION_STRING "1.3-pre-2"

#define LINE 1024
#define REGOPTS REG_EXTENDED|REG_NOSUB|REG_ICASE

#include <regex.h>
#include <zephyr/zephyr.h>
#include <netdb.h>

typedef struct _zlogger_list {
  int size;
  int avail;
  void **list;
} zlogger_list;

typedef struct _zlogger_entry {
  char *name;
  char *class;
  regex_t instance;
  regex_t opcode;
  int negateinstance;
  int negateopcode;
  char *logfile;
  int logfilenoparse;
  int nolog;
  int logroll;
  int loglife;
} zlogger_entry;

typedef struct _zlogger_global {
  zlogger_list entrylist;
  char *v5ticketfile;
  char *v4ticketfile;
  char *keytab;
  char *kservice;
  char *aklog;
  int noafs;
  int newtickets; /* in hours   */
  int newsubs;    /* in minutes */
  char hostname[MAXHOSTNAMELEN];
  char *cells;
  int debug;
} zlogger_global;

/* Global variables */
extern zlogger_global g;

/* Function prototypes */
/* -------------------------------- entry.c -------------------------------- */
extern void zlogger_entry_init(zlogger_entry *e, char *name);
extern char *zlogger_entry_get_name(zlogger_entry *e);
extern int zlogger_entry_set_class(zlogger_entry *e, char *class);
extern char *zlogger_entry_get_class(zlogger_entry *e);
extern int zlogger_entry_set_instance(zlogger_entry *e, char *instance);
extern void zlogger_entry_set_noparse(zlogger_entry *e);
extern int zlogger_entry_is_noparse(zlogger_entry *e);
extern int zlogger_entry_set_opcode(zlogger_entry *e, char *opcode);
extern int zlogger_entry_is_match(zlogger_entry *e, char *class, char *inst, char *opcode);
extern void zlogger_entry_set_logfile(zlogger_entry *e, char *filename);
extern char *zlogger_entry_get_logfile(zlogger_entry *e);
extern void zlogger_entry_set_nolog_on(zlogger_entry *e);
extern void zlogger_entry_set_nolog_off(zlogger_entry *e);
extern int zlogger_entry_is_nolog(zlogger_entry *e);
extern void zlogger_entry_set_logroll_on(zlogger_entry *e);
extern void zlogger_entry_set_loglife_days(zlogger_entry *e, int days);
extern int zlogger_entry_is_logroll(zlogger_entry *e);
extern int zlogger_entry_get_loglife_days(zlogger_entry *e);

/* -------------------------------- global.c -------------------------------- */
extern void zlogger_global_init(zlogger_global *g);
extern void zlogger_global_set_debug(zlogger_global *g);
extern int zlogger_global_is_debug(zlogger_global *g);
extern void *zlogger_global_get_entrylist(zlogger_global *g);
extern void zlogger_global_set_ticketfile(zlogger_global *g, char *ticketfile);
extern char *zlogger_global_get_v4_ticketfile(zlogger_global *g);
extern char *zlogger_global_get_v5_ticketfile(zlogger_global *g);
extern void zlogger_global_set_keytab(zlogger_global *g, char *keytab);
extern char *zlogger_global_get_keytab(zlogger_global *g);
extern void zlogger_global_set_kservice(zlogger_global *g, char *kservice);
extern char *zlogger_global_get_kservice(zlogger_global *g);
extern void zlogger_global_set_newtix_hours(zlogger_global *g, int hours);
extern int zlogger_global_get_newtix_hours(zlogger_global *g);
extern void zlogger_global_set_newsubs_minutes(zlogger_global *g, int minutes);
extern int zlogger_global_get_newsubs_minutes(zlogger_global *g);
extern void zlogger_global_set_cells(zlogger_global *g, char *cells);
extern char *zlogger_global_get_cells(zlogger_global *g);
extern void zlogger_global_set_aklog(zlogger_global *g, char *aklog);
extern char *zlogger_global_get_aklog(zlogger_global *g);
extern void zlogger_global_set_noafs(zlogger_global *g);
extern int zlogger_global_is_noafs(zlogger_global *g);

/* -------------------------------- list.c -------------------------------- */
extern int zlogger_list_create(zlogger_list *l);
extern int zlogger_list_get_size(zlogger_list *l);
extern void *zlogger_list_get_element(zlogger_list *l, int n);
extern int zlogger_list_append_element(zlogger_list *l, void *element);
extern int zlogger_list_prepend_element(zlogger_list *l, void *element);
extern int zlogger_list_remove_element(zlogger_list *l, int n);
extern int zlogger_list_replace_element(zlogger_list *l, int n, void *element);
extern void zlogger_list_free_all(zlogger_list *l, void (*elefree)(void *));
extern void zlogger_list_free_simple(zlogger_list *l);

/* -------------------------------- util.c -------------------------------- */
extern int is_weird(char *instance);
extern void securefile(char *path);
extern char *zlogger_util_replace(char *in, char *from, char *to);
extern int k54srvutil(char *service, char *keytabfile, int interactive);
extern char **atokenize(char *buffer, char *sep, int *i);
extern void downstr(char *foo);

/* -------------------------------- zlogger.c -------------------------------- */
extern int main(int argc, char **argv);
extern int zlogger_readconfig(char *filename);
extern void argserr(char *key, int line);
extern void keyerr(char *key, int line);
extern void regexerr(char *reg, int line);
extern int zlogger_get_tickets_and_tokens(int interactive);
extern void zlogger_zephyr_getsubs();
extern void zlogger_log_notice(ZNotice_t *notice);
extern void zlogger_log_writelog(zlogger_entry *e, ZNotice_t *notice);
extern void zlogger_log_turnover();
extern void zlogger_log_initlogs();
extern void zlogger_print_conf_debug();

